/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class MalTimerTaskUpgradeOp
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(MalTimerTaskUpgradeOp.class);
    private static final String[] taskNumbers = new String[]{"mal_AutoReturnTask_SKDP_S", "mal_GoodsCopyToFullText_SKDP_S", "mal_JdStatusUpdateTask_SKDP_S", "pur_JdOrderToReceipt_SKDP_S"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5546\u57ce\u5b9a\u65f6\u4efb\u52a1\u5347\u7ea7\u3002", (String)"MalTimerTaskUpgradeOp_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u5347\u7ea7\u5546\u57ce\u5b9a\u65f6\u4efb\u52a1\u5b8c\u6bd5\u3002", (String)"MalTimerTaskUpgradeOp_1", (String)"scm-mal-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u5347\u7ea7\u5546\u57ce\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\u3002", (String)"MalTimerTaskUpgradeOp_2", (String)"scm-mal-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        if (this.isJdAutoExists()) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4f7f\u7528\u4eac\u4e1c\u5546\u57ce\uff0c\u65e0\u9700\u7981\u7528\u3002\n", (String)"MalTimerTaskUpgradeOp_3", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            return true;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        String updateSql = "update t_sch_schedule set fstatus = ? where fid = ?";
        String selectProperties = "id,number,status";
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", (Object)taskNumbers).and(new QFilter("status", "=", (Object)"1"))};
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"sch_schedule", (String)selectProperties, (QFilter[])filters);
        logger.info("\u5f85\u66f4\u65b0\u7684\u8c03\u5ea6\u8ba1\u5212\u6761\u6570\uff1a" + dyoCol.size());
        if (dyoCol.size() <= 0) {
            pProcessInfo.append(ResManager.loadKDString((String)"\u65e0\u5f85\u66f4\u65b0\u7684\u8c03\u5ea6\u8ba1\u5212\u6761\u6570\n", (String)"MalTimerTaskUpgradeOp_4", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            return true;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(dyoCol.size());
        for (DynamicObject dyo : dyoCol) {
            Object[] objects = new Object[]{"0", dyo.getString("id")};
            paramList.add(objects);
            scheduleManager.disableSchedule(dyo.getString("id"));
        }
        DBRoute dbRoute = new DBRoute(dbKey);
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramList);
            }
            catch (Exception e) {
                handle.markRollback();
                boolean bl = false;
                if (handle != null) {
                    if (var11_11 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private boolean isJdAutoExists() {
        String sql = "select fid,fopenstatus from t_mal_ecadmit where fplatform = '2' and fopenstatus = '2'";
        DBRoute dbRoute = new DBRoute("pur");
        try (DataSet ds = DB.queryDataSet((String)"MalTimerTaskUpgradeOp.beforeExecuteUnEqulesSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
            boolean bl = !ds.isEmpty();
            return bl;
        }
    }
}

