/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.enums.MalBizflowParamEnum;

public class MalOrderToPmOrderUtil {
    private static Log log = LogFactory.getLog(MalOrderToPmOrderUtil.class);

    public static void pushPurBill(List<ExtendedDataEntity> objs) {
        String srcEntityKey = "mal_order";
        String targetEntityKey = "pm_purorderbill";
        ArrayList<String> billids = new ArrayList<String>(objs.size());
        for (ExtendedDataEntity obj : objs) {
            DynamicObject bill = obj.getDataEntity();
            billids.add(bill.getPkValue().toString());
        }
        DynamicObjectCollection billColl = MalOrderToPmOrderUtil.assemblePushBillData(billids, srcEntityKey);
        if (null != billColl) {
            String msg;
            log.info("@@@\u5546\u57ce\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0a\u6e38\u5355\u636e\u4eac\u4e1c\u8ba2\u5355\u53f7\u4e3a\uff1a" + ((DynamicObject)billColl.get(0)).getString("jdorderid"));
            Long malOrderCreatorId = ((DynamicObject)billColl.get(0)).getLong("creator.id");
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntityKey);
            pushArgs.setTargetEntityNumber(targetEntityKey);
            pushArgs.setBuildConvReport(false);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : billColl) {
                ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
                row.setEntryEntityKey("entryentity");
                row.setEntryPrimaryKeyValue((Object)billData.getLong("entryentity"));
                selectedRowList.add(row);
            }
            if (selectedRowList.size() == 0) {
                return;
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            catch (Exception e) {
                log.error("\u5546\u57ce\u8ba2\u5355\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"MalOrderToPmOrderUtil_0", (String)"scm-mal-opplugin", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("push error", msg + ":" + e.getMessage()), new Object[]{e.getMessage()});
            }
            ArrayList<DynamicObject> targetBills = new ArrayList<DynamicObject>();
            if (result != null && result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
                IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                    }
                };
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                targetBills.addAll(targetData);
                OperationResult saveResult = MalOrderToPmOrderUtil.doSaveOperation(targetEntityKey, targetBills, malOrderCreatorId);
                if (saveResult == null || !saveResult.isSuccess()) {
                    return;
                }
                String bizflow = MalOrderUtil.getBizFlowParam();
                log.info("@@@\u5546\u57ce\u4e1a\u52a1\u6d41\u7a0b\u53c2\u6570\uff1a" + bizflow);
                if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                    OperationResult submitResult = MalOrderToPmOrderUtil.doSubmitOperation(targetEntityKey, saveResult.getSuccessPkIds(), false);
                    MalOrderToPmOrderUtil.doAuditOperation(targetEntityKey, submitResult);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
                    MalOrderToPmOrderUtil.doSubmitOperation(targetEntityKey, saveResult.getSuccessPkIds(), true);
                }
            } else {
                if (result != null) {
                    result.getBillReports();
                    log.error("@@@MalOrderToPmOrderUtil.pushBill:\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getMessage());
                    msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c{0},", (String)"MalOrderToPmOrderUtil_1", (String)"scm-mal-opplugin", (Object[])new Object[]{result.getMessage()});
                    throw new KDBizException(new ErrorCode("push error", msg + ExceptionUtil.getBillPushReportsErrorMsg((ConvertOperationResult)result)), new Object[]{ExceptionUtil.getBillPushReportsErrorMsg((ConvertOperationResult)result)});
                }
                log.error("@@@MalOrderToPmOrderUtil.pushBill:\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0");
                msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderToPmOrderUtil_2", (String)"scm-mal-opplugin", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("push error", msg), new Object[0]);
            }
        }
    }

    public static DynamicObjectCollection assemblePushBillData(List<String> billids, String srcEntityKey) {
        HashMap queryFilterMap = new HashMap(1);
        HashMap billidMap = new HashMap(1);
        ArrayList<Long> ids = new ArrayList<Long>(billids.size());
        for (String billId : billids) {
            ids.add(Long.valueOf(billId));
        }
        billidMap.put("in", ids);
        queryFilterMap.put("id", billidMap);
        return ORMUtil.queryDynamicObjectCollection((String)srcEntityKey, (String)"id,entryentity.id entryentity,creator.id,jdorderid", queryFilterMap);
    }

    public static OperationResult doOperation(String operation, List ids, String entity, boolean isWF) {
        if (StringUtils.isBlank((CharSequence)entity) || StringUtils.isBlank((CharSequence)operation) || ids == null || ids.size() == 0) {
            throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u8c03\u7528\u91c7\u8d2d\u8ba2\u5355\u4f20\u9012\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"MalOrderToPmOrderUtil_3", (String)"scm-mal-opplugin", (Object[])new Object[0])), new Object[0]);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        if (!isWF) {
            option.setVariableValue("WF", String.valueOf(isWF));
        }
        OperationResult result = null;
        result = OperationServiceHelper.executeOperate((String)operation, (String)entity, (Object[])ids.toArray(new Object[0]), (OperateOption)option);
        return result;
    }

    protected static OperationResult doSaveOperation(String targetEntityKey, List<DynamicObject> targetBills, Long malOrderCreatorId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        option.setVariableValue("WF", String.valueOf(false));
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doSaveOperation-->\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u8ba2\u5355\u4fdd\u5b58\u64cd\u4f5c");
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetEntityKey, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
        if (saveResult != null && !saveResult.isSuccess()) {
            String message = ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo());
            log.error("@@@MalOrderToPmOrderUtil.doSaveOperation:\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + message);
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalOrderToPmOrderUtil_4", (String)"scm-mal-opplugin", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("operation error", msg + ":" + message), new Object[]{message});
        }
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doSaveOperation-->\u5b8c\u6210\u91c7\u8d2d\u4fdd\u5b58\u63d0\u4ea4\u64cd\u4f5c");
        return saveResult;
    }

    public void handleAfterSaveTargetData(OperationResult opResult, String entity, Long srcCreatorId) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("id", "in", (Object)opResult.getSuccessPkIds().toArray(new Long[0]));
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)srcCreatorId, (String)"bos_user");
        String selectFileds = "id,creator,modifier";
        for (DynamicObject dyo : dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)selectFileds, (QFilter[])new QFilter[]{filter})) {
            dyo.set("creator_id", (Object)srcCreatorId);
            dyo.set("creator", (Object)user);
            dyo.set("modifier_id", (Object)srcCreatorId);
            dyo.set("modifier", (Object)user);
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("handle target err", ResManager.loadKDString((String)"\u5904\u7406\u76ee\u6807\u5355\u5f02\u5e38\u3002", (String)"MalOrderToPmOrderUtil_5", (String)"scm-mal-opplugin", (Object[])new Object[0])), new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
    }

    protected static OperationResult doSubmitOperation(String targetEntityKey, List ids, boolean isWF) {
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doSubmitOperation-->\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u8ba2\u5355\u63d0\u4ea4\u64cd\u4f5c");
        OperationResult submitresult = MalOrderToPmOrderUtil.doOperation("submit", ids, "pm_purorderbill", isWF);
        if (submitresult != null && !submitresult.isSuccess()) {
            MalOrderToPmOrderUtil.rollBackPurOrder(ids, targetEntityKey);
            String message = ExceptionUtil.getErrorInfoDetails((List)submitresult.getAllErrorOrValidateInfo());
            log.error("@@@MalOrderToPmOrderUtil.pushBill:\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + message);
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u63d0\u4ea4\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:", (String)"MalOrderToPmOrderUtil_6", (String)"scm-mal-opplugin", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("operation error", msg + ":" + message), new Object[]{message});
        }
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doSubmitOperation-->\u5b8c\u6210\u91c7\u8d2d\u8ba2\u5355\u63d0\u4ea4\u64cd\u4f5c");
        return submitresult;
    }

    protected static void doAuditOperation(String targetEntityKey, OperationResult submitResult) {
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doAuditOperation-->\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u8ba2\u5355\u5ba1\u6838\u64cd\u4f5c");
        if (submitResult == null) {
            return;
        }
        List ids = submitResult.getSuccessPkIds();
        OperationResult auditResult = MalOrderToPmOrderUtil.doOperation("audit", ids, "pm_purorderbill", false);
        if (auditResult != null && !auditResult.isSuccess()) {
            MalOrderToPmOrderUtil.rollBackPurOrder(ids, targetEntityKey);
            String massage = ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo());
            log.error("@@@MalOrderAuditOp.pushBill:\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + massage);
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u5ba1\u6838\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MalOrderToPmOrderUtil_7", (String)"scm-mal-opplugin", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("operation error", msg + ":" + massage), new Object[]{massage});
        }
        log.info("@@@kd.scm.mal.opplugin.MalOrderToPmOrderUtil.doAuditOperation-->\u5b8c\u6210\u91c7\u8d2d\u8ba2\u5355\u5ba1\u6838\u64cd\u4f5c");
    }

    private static void rollBackPurOrder(List ids, String entityname) {
        if (ids != null && ids.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("ids", ids);
                map.put("operation", "delete");
                map.put("entity", "pm_purorderbill");
                MalOrderToPmOrderUtil.doOperation("delete", ids, "pm_purorderbill", false);
            }
            catch (Exception e) {
                log.error("@@@MalOrderToPmOrderUtil.rollBackPurOrder:\u56de\u6eda\u5f02\u5e38\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + ids.toString() + "\n" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }
}

