/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.botp;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.mal.common.aftersale.impl.MalAutoReturnService;

@Deprecated
public class MalReturnReqToImPurReceiveBillPlugin
extends AbstractConvertPlugIn {
    private static String EXRATETABLE_DT = "bd_exratetable";
    private static String EXRATETABLE = "exchangeRateTableID";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        this.validate(e);
    }

    protected void validate(BeforeBuildRowConditionEventArgs e) {
        if (e.getSelectedRows().isEmpty()) {
            return;
        }
        DynamicObjectCollection malOrderDynCol = new MalAutoReturnService().queryRelatedMalOrder((Long)((ListSelectedRow)e.getSelectedRows().get(0)).getPrimaryKeyValue());
        for (DynamicObject malOrderDyn : malOrderDynCol) {
            if (malOrderDyn.getBigDecimal("entryentity.sumreceiptqty").compareTo(BigDecimal.ZERO) > 0) continue;
            e.setCustFilterDesc(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355{0}\u6ca1\u6709\u6536\u8d27\uff0c\u552e\u540e\u7533\u8bf7\u4e0b\u63a8\u4e0d\u53ef\u4ee5\u4e0b\u63a8\u751f\u6210\u7ea2\u5b57\u6536\u8d27\u5355\u3002", (String)"MalReturnReqToImPurReceiveBillPlugin_0", (String)"scm-mal-opplugin", (Object[])new Object[0]), malOrderDyn.getString("billno")));
            e.setCustFilterExpression("id < 0");
            return;
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey("im_purreceivebill")) {
            DynamicObject exRateTable;
            DynamicObject obj = entity.getDataEntity();
            DynamicObject currency = obj.getDynamicObject("currency");
            DynamicObject org = obj.getDynamicObject("org");
            if (org == null) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = this.getCurrency(orgId);
                obj.set("currency", (Object)currency);
            }
            if ((exRateTable = obj.getDynamicObject("exratetable")) == null) {
                exRateTable = this.getExRateTable(orgId);
                obj.set("exratetable", (Object)exRateTable);
            }
            this.setExchangeRate(obj);
            this.setEntries(obj);
        }
    }

    private void setEntries(DynamicObject obj) {
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            DynamicObject companyOrg = entry.getDynamicObject("entrysettleorg");
            if (null == companyOrg) continue;
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal qty = entry.getBigDecimal("qty");
            if (material == null) continue;
            DynamicObject baseUnit = material.getDynamicObject("masterid.baseunit");
            entry.set("baseunit", (Object)baseUnit);
            if (qty == null || unit == null || baseUnit == null) continue;
            BigDecimal baseQty = this.getDesQtyConv(material, unit, qty, baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private void setExchangeRate(DynamicObject obj) {
        Long texrateTableId;
        DynamicObject currency = obj.getDynamicObject("currency");
        DynamicObject settleCurrency = obj.getDynamicObject("settlecurrency");
        Date exrateDate = obj.getDate("exratedate");
        DynamicObject exratetable = obj.getDynamicObject("exratetable");
        Long l = texrateTableId = exratetable == null ? null : Long.valueOf(exratetable.getLong("id"));
        if (currency != null && settleCurrency != null) {
            if (currency.getPkValue().equals(settleCurrency.getPkValue())) {
                obj.set("exchangerate", (Object)new BigDecimal(1));
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)texrateTableId, (Long)settleCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)exrateDate);
                if (exchangeRate == null) {
                    obj.set("exchangerate", null);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6c47\u7387\uff0c\u8bf7\u5728\u5f53\u524d\u6c47\u7387\u8868\u4e2d\u7ed9\u672c\u4f4d\u5e01\u548c\u7ed3\u7b97\u5e01\u522b\u914d\u7f6e\u3002", (String)"MalReturnReqToImPurReceiveBillPlugin_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                }
                obj.set("exchangerate", (Object)exchangeRate);
            }
        }
    }

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            BigDecimal unitRate;
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                int unitPrecision = desUnit.getInt("precision");
                if (StringUtil.isNotBlank((CharSequence)desUnit.getString("precisionaccount"))) {
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                }
            }
        }
        return qty;
    }

    private DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map;
        if (orgId != 0L && (map = this.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get("baseCurrencyID"), (String)"bd_currency");
        }
        return null;
    }

    private Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    private DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = this.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }
}

