/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MalToPurOrderConvertPlugin
extends AbstractConvertPlugIn {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        List<DynamicObject> bills = new ArrayList<DynamicObject>(entitys.length);
        HashSet<Long> malOrderEntryIds = new HashSet<Long>(1024);
        for (ExtendedDataEntity entity : entitys) {
            bills.add(entity.getDataEntity());
        }
        for (DynamicObject info : bills) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("billentry");
            for (DynamicObject row : entrys) {
                if (0L == row.getLong("srcbillentryid")) continue;
                malOrderEntryIds.add(row.getLong("srcbillentryid"));
            }
        }
        if (!ObjectUtils.isEmpty(bills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"batchSetPODefValue", (Object[])new Object[]{bills}))) {
            e.getTargetExtDataEntitySet().Parse(bills.toArray(new DynamicObject[0]), (MainEntityType)this.getTgtMainType());
        }
        if (malOrderEntryIds.size() > 0) {
            this.setContract(malOrderEntryIds, bills);
        }
    }

    private void setContract(Set<Long> malOrderEntryIds, List<DynamicObject> dyos) {
        QFilter qFilter = new QFilter("entryentity.id", "in", malOrderEntryIds);
        String selectors = "entryentity.protocolsourceid,entryentity.protocolsourceentryid,entryentity.erpsourcebilltype,entryentity.erpsourceid,entryentity.id,entryentity.erpsourceentryid";
        DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<Long> protocolIds = new HashSet<Long>(1024);
        for (DynamicObject info : malOrders) {
            if (info.getString("entryentity.protocolsourceid").isEmpty()) continue;
            protocolIds.add(info.getLong("entryentity.protocolsourceid"));
        }
        this.log.info("protocolIds = " + protocolIds);
        if (protocolIds.size() > 0) {
            qFilter = new QFilter("id", "in", protocolIds);
            DynamicObjectCollection protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"srcid,entryentity1.srcbillentryseq,entryentity1.id,id,billno,prosource,entryentity1.srcbillid,entryentity1.srcbillentryid,srcbillbillno", (QFilter[])qFilter.toArray());
            HashMap<String, String> proId_NoMap = new HashMap<String, String>(1024);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder keyStrBuilder = new StringBuilder();
            for (DynamicObject info : protocols) {
                if (!"2".equals(info.getString("prosource"))) continue;
                stringBuilder.setLength(0);
                keyStrBuilder.setLength(0);
                Long srcbillid = info.getLong("srcid");
                String srcbillbillno = info.getString("srcbillbillno");
                Long srcbillentryid = info.getLong("entryentity1.srcbillentryid");
                Long entryId = info.getLong("entryentity1.id");
                int seq = info.getInt("entryentity1.srcbillentryseq");
                stringBuilder.append(srcbillid).append("_").append(srcbillentryid).append("_").append(srcbillbillno).append("_").append(seq);
                keyStrBuilder.append(info.getLong("id")).append("_").append(entryId);
                proId_NoMap.put(keyStrBuilder.toString(), stringBuilder.toString());
                stringBuilder.setLength(0);
                keyStrBuilder.setLength(0);
                stringBuilder.append(srcbillid).append("_").append(0L).append("_").append(srcbillbillno).append("_").append(0);
                keyStrBuilder.append(info.getLong("id")).append("_").append(0L);
                proId_NoMap.put(keyStrBuilder.toString(), stringBuilder.toString());
            }
            this.log.info("proId_NoMap = " + SerializationUtils.toJsonString(proId_NoMap));
            HashMap<Long, String> malOrderEid_ProMap = new HashMap<Long, String>(1024);
            for (DynamicObject info : malOrders) {
                if (info.getString("entryentity.protocolsourceid").isEmpty()) continue;
                keyStrBuilder.setLength(0);
                Long entryId = info.getLong("entryentity.id");
                Long proId = info.getLong("entryentity.protocolsourceid");
                Long proEntryId = info.getLong("entryentity.protocolsourceentryid");
                keyStrBuilder.append(proId).append("_").append(proEntryId);
                String proNoStr = (String)proId_NoMap.get(keyStrBuilder.toString());
                malOrderEid_ProMap.put(entryId, proNoStr);
            }
            this.log.info("malOrderEid_ProMap = " + SerializationUtils.toJsonString(malOrderEid_ProMap));
            for (DynamicObject dyo : dyos) {
                DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("billentry");
                for (DynamicObject entrydyo : entryCol) {
                    String key;
                    long srcentryid = entrydyo.getLong("srcbillentryid");
                    if (!malOrderEid_ProMap.containsKey(srcentryid) || null == (key = (String)malOrderEid_ProMap.get(srcentryid)) || key.isEmpty()) continue;
                    String[] proStrs = key.split("_");
                    entrydyo.set("conbillid", (Object)Long.parseLong(proStrs[0]));
                    if (0L != Long.parseLong(proStrs[1]) && !proStrs[1].isEmpty()) {
                        entrydyo.set("conbillentryid", (Object)Long.parseLong(proStrs[1]));
                        entrydyo.set("conbillrownum", (Object)proStrs[3]);
                    }
                    entrydyo.set("conbillnumber", (Object)proStrs[2]);
                }
            }
        }
    }
}

