/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ExceptionUtil;

public class MalOrderCancelEventServicelPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(MalOrderCancelEventServicelPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("mal_order.cancel.executePlugin start");
        logger.info("EntityEventNumber:" + evt.getEventNumber() + ", EntityEventId" + evt.getEventId());
        EntityEvent entityEvent = null;
        if (evt instanceof EntityEvent) {
            entityEvent = (EntityEvent)evt;
        }
        if (entityEvent == null) {
            logger.info("mal_order.cancel.executePlugin: evt == null");
            return evt.getEventId();
        }
        if (!ApiConfigUtil.hasCQScmConfig()) {
            return evt.getEventId();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(entityEvent.getBusinesskeys().size());
        for (String businesskey : entityEvent.getBusinesskeys()) {
            pkIds.add(Long.valueOf(businesskey));
        }
        this.writePmByMalOrder(pkIds);
        return evt.getEventId();
    }

    private void writePmByMalOrder(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        qFilter.and(new QFilter("entryentity.entrystatus", "=", (Object)"F"));
        String selectors = "billstatus,id,entryentity.id,entryentity.entrystatus";
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"mal_order", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<Long> allCancelIds = new HashSet<Long>(16);
        HashSet<Long> allCancelEntryIds = new HashSet<Long>(16);
        for (DynamicObject order : orders) {
            long id = order.getLong("id");
            long entryId = order.getLong("entryentity.id");
            allCancelIds.add(id);
            allCancelEntryIds.add(entryId);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", String.valueOf(true));
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"mal_order", (String)"entryentity", (Long[])new ArrayList(allCancelIds).toArray(new Long[0]), (Long[])new ArrayList(allCancelEntryIds).toArray(new Long[0]), (OperateOption)option);
        HashMap partCancelMap = new HashMap(16);
        for (BFRowLinkDownNode bfRow : bfRowLinkDownNodes) {
            Map tNodes = bfRow.getTNodes();
            for (Map.Entry tNode : tNodes.entrySet()) {
                Long billId = ((BFRowId)tNode.getKey()).getBillId();
                Set<Long> entryIds = new HashSet<Long>(16);
                if (null != partCancelMap.get(billId)) {
                    entryIds = (Set)partCancelMap.get(billId);
                }
                entryIds.add(((BFRowId)tNode.getKey()).getEntryId());
                partCancelMap.put(billId, entryIds);
            }
        }
        if (partCancelMap.size() > 0) {
            option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (Map.Entry map : partCancelMap.entrySet()) {
                Set entryIds = (Set)map.getValue();
                for (Long entryId : entryIds) {
                    ListSelectedRow listSelectedRow = new ListSelectedRow(map.getKey());
                    listSelectedRow.setEntryEntityKey("billentry");
                    listSelectedRow.setEntryPrimaryKeyValue((Object)entryId);
                    listSelectedRows.add((Object)listSelectedRow);
                }
            }
            String listSelectedRowsStr = SerializationUtils.toJsonString((Object)listSelectedRows);
            option.setVariableValue("bos_listselectedrowcollection", listSelectedRowsStr);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"rowterminate", (String)"pm_purorderbill", (Object[])partCancelMap.keySet().toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                logger.info(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            }
        }
    }
}

