/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.malcore.domain.GoodsSameRule;

public class MalPlaceOrderMakeOrderEventPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(MalPlaceOrderMakeOrderEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        Map goodsId_CompareIdMap;
        logger.info("mal_placeorder_makeorder start");
        logger.info("EntityEventNumber:" + evt.getEventNumber() + ", EntityEventId" + evt.getEventId());
        JsonEvent jsonEvent = null;
        if (evt instanceof JsonEvent) {
            jsonEvent = (JsonEvent)evt;
        }
        if (jsonEvent == null) {
            logger.info("mal_placeorder_makeorder_placeorder_makeorder: evt == null");
            return evt.getEventId();
        }
        String dataSource = evt.getSource();
        List parmas = (List)SerializationUtils.fromJsonString((String)dataSource, List.class);
        if (parmas.size() == 0) {
            return evt.getEventId();
        }
        Map dataMap = (Map)parmas.get(0);
        if (null == dataMap.get("orderIds")) {
            return evt.getEventId();
        }
        List orderId = (List)dataMap.get("orderIds");
        if (null == dataMap.get("goodsIds")) {
            return evt.getEventId();
        }
        List goodsIds = (List)dataMap.get("goodsIds");
        if (null == dataMap.get("orgId")) {
            return evt.getEventId();
        }
        long orgId = Long.parseLong(String.valueOf(dataMap.get("orgId")));
        if (null == dataMap.get("opuserId")) {
            return evt.getEventId();
        }
        long userId = Long.parseLong(String.valueOf(dataMap.get("opuserId")));
        logger.info("param=" + dataSource);
        HashMap goodsId_SameKindMap = new HashMap(16);
        if (goodsIds.size() == 0) {
            return evt.getEventId();
        }
        Map goodsSameRuleMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"batchGetSameGoodsRuleEsFilterByGoodsIds", (Object[])new Object[]{new HashSet(goodsIds)});
        if (null == goodsSameRuleMap || goodsSameRuleMap.size() == 0) {
            return evt.getEventId();
        }
        Collection values = goodsSameRuleMap.values();
        GoodsSameRule[] goodsSameRules = values.toArray(new GoodsSameRule[0]);
        if (!goodsSameRules[0].isAutoCompare()) {
            return evt.getEventId();
        }
        for (Map.Entry sameRuleMap : goodsSameRuleMap.entrySet()) {
            GoodsSameRule goodsSameRule = (GoodsSameRule)sameRuleMap.getValue();
            long l = (Long)sameRuleMap.getKey();
            if (goodsSameRule.getEsFilterFields() == null || goodsSameRule.getEsFilterFields().size() == 0) continue;
            MalSearchParam malSearchParam = new MalSearchParam();
            malSearchParam.setCustomEsFilterFields(goodsSameRule.getEsFilterFields());
            malSearchParam.setSort(goodsSameRule.getSort());
            malSearchParam.setPageNum(0);
            malSearchParam.setPageSize(10);
            MalSearchResult malSearchResult = ((MalSearchService)MalBusinessFactory.serviceOf(MalSearchService.class)).search(malSearchParam, null);
            List resultData = malSearchResult.getResultData();
            ArrayList<Long> sameKindIds = new ArrayList<Long>(16);
            for (Map resultDataMap : resultData) {
                long resGoodsId = Long.parseLong(String.valueOf(resultDataMap.get("goodsid")));
                if (l == resGoodsId) continue;
                sameKindIds.add(resGoodsId);
                if (sameKindIds.size() != 9) continue;
                break;
            }
            if (sameKindIds.size() <= 0) continue;
            goodsId_SameKindMap.put(l, sameKindIds);
        }
        logger.info("goodsId_SameKindMap=" + SerializationUtils.toJsonString(goodsId_SameKindMap));
        if (goodsId_SameKindMap.size() > 0 && (goodsId_CompareIdMap = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addComparePriceRecord(goodsId_SameKindMap, Long.valueOf(userId), Long.valueOf(orgId))).size() > 0) {
            logger.info("goodsId_CompareIdMap=" + SerializationUtils.toJsonString((Object)goodsId_CompareIdMap));
            HashSet<Long> compareIds = new HashSet<Long>(16);
            for (Map.Entry entry : goodsId_CompareIdMap.entrySet()) {
                compareIds.add((Long)entry.getValue());
            }
            Set<Long> lowPriceGoodsIdByCompareId = this.getLowPriceGoodsIdByCompareId(compareIds);
            logger.info("lowPriceGoodsIdByCompareId=" + SerializationUtils.toJsonString(lowPriceGoodsIdByCompareId));
            this.writeCompareId2OrderByOrderId(lowPriceGoodsIdByCompareId, goodsId_CompareIdMap, orderId);
        }
        logger.info("mal_placeOrder_makeOrder---end");
        return evt.getEventId();
    }

    private void writeCompareId2OrderByOrderId(Set<Long> lowPriceGoodsIdByCompareId, Map<Long, Long> goodsId_compareIdMap, List<Long> orderId) {
        DynamicObject[] orders;
        QFilter qFilter = new QFilter("id", "in", orderId);
        for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)"mal_order", (String)"entryentity.goods,entryentity.compareid,entryentity.compareresult", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entry = order.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                long goodsId;
                if (null == row.get("goods") || null == goodsId_compareIdMap.get(goodsId = row.getLong("goods.id"))) continue;
                row.set("compareid", (Object)String.valueOf(goodsId_compareIdMap.get(goodsId)));
                if (lowPriceGoodsIdByCompareId.contains(goodsId)) {
                    row.set("compareresult", (Object)"B");
                    continue;
                }
                row.set("compareresult", (Object)"C");
            }
        }
        if (orders.length > 0) {
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    private Set<Long> getLowPriceGoodsIdByCompareId(Set<Long> compareIds) {
        HashSet<Long> lowerPriceGoodIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", compareIds);
        DynamicObjectCollection mal_compareprice = QueryServiceHelper.query((String)"mal_compareprice", (String)"entryentity.isadd,entryentity.compareresult,entryentity.goods", (QFilter[])qFilter.toArray());
        for (DynamicObject row : mal_compareprice) {
            boolean isAdd = row.getBoolean("entryentity.isadd");
            String compareresult = row.getString("entryentity.compareresult");
            long goodsId = row.getLong("entryentity.goods");
            if (!isAdd || !"1".equals(compareresult)) continue;
            lowerPriceGoodIds.add(goodsId);
        }
        return lowerPriceGoodIds;
    }
}

