/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.event;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.LogisticsStatusEnum;

public class MalPurOrderAuditEventPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(MalPurOrderAuditEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("pur_order.audit.executePlugin start");
        logger.info("EntityEventNumber:" + evt.getEventNumber() + ", EntityEventId" + evt.getEventId());
        EntityEvent entityEvent = null;
        if (evt instanceof EntityEvent) {
            entityEvent = (EntityEvent)evt;
        }
        if (entityEvent == null) {
            logger.info("pur_order.audit.executePlugin: evt == null");
            return evt.getEventId();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(entityEvent.getBusinesskeys().size());
        for (String businesskey : entityEvent.getBusinesskeys()) {
            pkIds.add(Long.valueOf(businesskey));
        }
        this.updateMalOrderInfo(pkIds);
        return evt.getEventId();
    }

    private void updateMalOrderInfo(List<Long> pkIds) {
        String properties = "id,billno,logstatus,billstatus,cfmstatus,materialentry.srcentryid srcentryid,materialentry.qty";
        DynamicObjectCollection purOrderDyns = QueryServiceHelper.query((String)"pur_order", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        logger.info("pur_order.audit.executePlugin: purOrderDyns:" + SerializationUtils.toJsonString((Object)purOrderDyns));
        ArrayList<Long> malEntryIdList = new ArrayList<Long>();
        HashMap<Long, String> malEntryIdNumberMap = new HashMap<Long, String>();
        HashMap<Long, String> malEntryIdLogStatusMap = new HashMap<Long, String>();
        HashMap<Long, String> malEntryIdBillStatusMap = new HashMap<Long, String>();
        HashMap<Long, BigDecimal> malEntryIdQtyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> malEntryIdCfmstatusMap = new HashMap<Long, String>();
        for (DynamicObject purOrderDyn : purOrderDyns) {
            long srcentryid = purOrderDyn.getLong("srcentryid");
            malEntryIdList.add(srcentryid);
            malEntryIdNumberMap.put(srcentryid, purOrderDyn.getString("billno"));
            malEntryIdLogStatusMap.put(srcentryid, purOrderDyn.getString("logstatus"));
            malEntryIdBillStatusMap.put(srcentryid, purOrderDyn.getString("billstatus"));
            malEntryIdQtyMap.put(srcentryid, purOrderDyn.getBigDecimal("materialentry.qty"));
            malEntryIdCfmstatusMap.put(srcentryid, purOrderDyn.getString("cfmstatus"));
        }
        DynamicObject[] mal_orders = BusinessDataServiceHelper.load((String)"mal_order", (String)"id,entryentity.id,entryentity.erpbillnumber,entryentity.erpbillstatus,entryentity.erplogstatus,entryentity.sumorderqty", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malEntryIdList)});
        logger.info("pur_order.audit.executePlugin: malEntryIdLogStatusMap:" + malEntryIdLogStatusMap);
        for (DynamicObject mal_order : mal_orders) {
            DynamicObjectCollection dynamicObjectCollection = mal_order.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : dynamicObjectCollection) {
                long entryEntityId = entryentity.getLong("id");
                if (!malEntryIdList.contains(entryEntityId)) continue;
                entryentity.set("erpbillnumber", malEntryIdNumberMap.get(entryEntityId));
                entryentity.set("erpbillstatus", malEntryIdBillStatusMap.get(entryEntityId));
                entryentity.set("sumorderqty", malEntryIdQtyMap.get(entryEntityId));
                String logStatus = (String)malEntryIdLogStatusMap.get(entryEntityId);
                if (StringUtils.isEmpty((CharSequence)logStatus)) {
                    String cfmstatus = (String)malEntryIdCfmstatusMap.get(entryEntityId);
                    if ("A".equals(cfmstatus)) {
                        entryentity.set("erplogstatus", (Object)LogisticsStatusEnum.BECONFIRMING.getVal());
                    }
                    if ("B".equals(cfmstatus)) {
                        entryentity.set("erplogstatus", (Object)LogisticsStatusEnum.CONFIRMED.getVal());
                    }
                    if (!"C".equals(cfmstatus)) continue;
                    entryentity.set("erplogstatus", (Object)LogisticsStatusEnum.REJECT.getVal());
                    continue;
                }
                entryentity.set("erplogstatus", malEntryIdLogStatusMap.get(entryEntityId));
            }
        }
        SaveServiceHelper.update((DynamicObject[])mal_orders);
        logger.info("pur_order.audit.executePlugin end");
    }
}

