/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.scmc;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CloseDateHelper {
    public static final List<String> TRANSFORMBILL = Arrays.asList("im_assembbill", "im_adjustbill", "im_disassemblebill");

    public static Map<String, Object> getCloseDateMap(String entityName, DynamicObject bill) {
        Date closeDate;
        HashMap<String, Object> closeDateMap = new HashMap<String, Object>(2);
        String inventory = "inv";
        Date invCloseDate = CloseDateHelper.getInvCloseDate(entityName, bill);
        Date calCloseDate = CloseDateHelper.getCalCloseDate(entityName, bill);
        if (null == invCloseDate && null == calCloseDate) {
            return null;
        }
        if (null != invCloseDate && null != calCloseDate) {
            if (invCloseDate.after(calCloseDate)) {
                closeDate = invCloseDate;
            } else {
                closeDate = calCloseDate;
                inventory = "cal";
            }
        } else if (null == invCloseDate) {
            closeDate = calCloseDate;
            inventory = "cal";
        } else {
            closeDate = invCloseDate;
        }
        closeDateMap.put("closeDate", closeDate);
        closeDateMap.put("key", inventory);
        return closeDateMap;
    }

    public static Date getInvCloseDate(String entityName, DynamicObject bill) {
        HashMap<Long, Set<Long>> orgWarehouseMap = CloseDateHelper.getAllOrgWarehouseMap(entityName, bill);
        QFilter closeFilter = CloseDateHelper.buildOrgWarehousesFilter(orgWarehouseMap);
        if (closeFilter == null) {
            return null;
        }
        closeFilter.and(new QFilter("isdelete", "<>", (Object)true));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"im_closeaccountrecord", (String)"im_closeaccountrecord", (String)"closedate", (QFilter[])closeFilter.toArray(), (String)"closedate desc").top(1);
        Date closeDate = null;
        for (Row row : dataSet) {
            closeDate = row.getDate("closedate");
        }
        return closeDate;
    }

    private static HashMap<Long, Set<Long>> getAllOrgWarehouseMap(String entityName, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject warehouseDyc = entry.getDynamicObject("warehouse");
            DynamicObject orgDyc = bill.getDynamicObject("org");
            CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, orgDyc, warehouseDyc);
            if (entityName.equals("im_transdirbill")) {
                DynamicObject outWarehouseDyc = entry.getDynamicObject("outwarehouse");
                DynamicObject outOrg = bill.getDynamicObject("outorg");
                CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, outOrg, outWarehouseDyc);
            }
            if (!TRANSFORMBILL.contains(entityName)) continue;
            DynamicObjectCollection afterEntryDycs = entry.getDynamicObjectCollection("afterentity");
            for (DynamicObject afterDyc : afterEntryDycs) {
                DynamicObject afterWarehouseDyc = afterDyc.getDynamicObject("warehouse1");
                CloseDateHelper.getAllOrgWarehouse(orgWarehouseMap, orgDyc, afterWarehouseDyc);
            }
        }
        return orgWarehouseMap;
    }

    private static void getAllOrgWarehouse(HashMap<Long, Set<Long>> orgWarehouseMap, DynamicObject org, DynamicObject warehouse) {
        if (CloseDateHelper.isNull(org) || CloseDateHelper.isNull(warehouse)) {
            return;
        }
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouse.getPkValue());
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).size() == 0) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    private static QFilter buildOrgWarehousesFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = null;
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters = orgWarehouseFilters == null ? orgWarehousef : orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    public static Set<Long> getAllOwnerIds(String entityName, DynamicObjectCollection entrys) {
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        for (DynamicObject entry : entrys) {
            Object owner = entry.get("owner");
            if (owner != null) {
                Long ownerId = ((DynamicObject)owner).getLong("id");
                ownerIds.add(ownerId);
            }
            if (TRANSFORMBILL.contains(entityName) || "im_locationtransfer".equals(entityName) || entry.get("outowner") == null) continue;
            Object outOwner = entry.get("outowner");
            Long outOwnerId = ((DynamicObject)outOwner).getLong("id");
            ownerIds.add(outOwnerId);
        }
        return ownerIds;
    }

    public static Date getCalCloseDate(String entityName, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Set<Long> ownerIds = CloseDateHelper.getAllOwnerIds(entityName, entrys);
        Map ownerCloseDate = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getOwnerCloseDate", (Object[])new Object[]{ownerIds});
        Map closeDateMap = (Map)ownerCloseDate.get("closeDate");
        Date calCloseDate = null;
        for (Object[] closeDate : closeDateMap.values()) {
            Date singleOwnerCloseDate = (Date)closeDate[0];
            if (calCloseDate == null) {
                calCloseDate = singleOwnerCloseDate;
                continue;
            }
            calCloseDate = calCloseDate.after(singleOwnerCloseDate) ? calCloseDate : singleOwnerCloseDate;
        }
        return calCloseDate;
    }

    public static void initBookDate(String entityId, DynamicObject bill) {
        Date closeDate;
        Date addDate;
        boolean bookDateBill = CloseDateHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), "bookdate");
        if (!bookDateBill) {
            return;
        }
        Date bookDate = (Date)bill.get("bookdate");
        Date bizDate = (Date)bill.get("biztime");
        if (null != bookDate) {
            return;
        }
        Map<String, Object> closeDateMap = CloseDateHelper.getCloseDateMap(entityId, bill);
        bookDate = null != closeDateMap ? (bizDate.before(addDate = CloseDateHelper.addOneDay(closeDate = (Date)closeDateMap.get("closeDate"))) ? addDate : (null == bizDate ? new Date() : bizDate)) : (null == bizDate ? new Date() : bizDate);
        bill.set("bookdate", (Object)bookDate);
    }

    public static boolean isExistField(IDataEntityType entityType, String fieldName) {
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = ((EntityType)entityType).findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    public static Date addOneDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, 1);
        return calendar.getTime();
    }
}

