/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.ApiConfigUtil;

public class BizTypeUpgradeUtil {
    private static Log logger = LogFactory.getLog(BizTypeUpgradeUtil.class);
    private static final int HEAD_PAGE_SIZE = 500;
    private static final String BIZTYPE = "BIZTYPE";
    private static final String LINETYPE = "LINETYPE";

    public static boolean upgrade(String dbKey, StringBuilder pProcessInfo, List<Object> targetIdList) {
        boolean hasCQSConfig = ApiConfigUtil.hasCQScmConfig();
        DBRoute dbRoute = new DBRoute(dbKey);
        BizTypeUpgradeUtil.updateBillTypeData(dbRoute);
        List<Object> orderIdList = null;
        boolean autoUpgrade = CollectionUtils.isEmpty(targetIdList);
        if (autoUpgrade) {
            String sqlOrderAll = "select fid from t_mal_order";
            orderIdList = BizTypeUpgradeUtil.getIdList(dbRoute, sqlOrderAll, "fid");
        } else {
            orderIdList = targetIdList;
        }
        String messge = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u83b7\u53d6\u5546\u57ce\u8ba2\u5355{0}\u6761\u6570\u636e\u3002", (String)"BizTypeUpgradeUtil_0", (String)"scm-mal-opplugin", (Object[])new Object[0]), orderIdList.size());
        pProcessInfo.append(messge).append("\n");
        DBRoute scmcDbRoute = new DBRoute("scm");
        int count = orderIdList.size();
        int totalPages = count / 500;
        if (count % 500 != 0) {
            ++totalPages;
        }
        pProcessInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u603b\u9875\u6570{0}", (String)"BizTypeUpgradeUtil_1", (String)"scm-mal-opplugin", (Object[])new Object[0]), totalPages)).append("\n");
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            Map<String, List<Object[]>> paramMap;
            List<Object> subIdList = (pageIndex + 1) * 500 > orderIdList.size() ? orderIdList.subList(pageIndex * 500, orderIdList.size()) : orderIdList.subList(pageIndex * 500, (pageIndex + 1) * 500);
            if (subIdList.isEmpty()) continue;
            Map<String, List<Object[]>> map = paramMap = hasCQSConfig ? BizTypeUpgradeUtil.getPmOrderPamraData(scmcDbRoute, subIdList) : BizTypeUpgradeUtil.getMalOrderPamraData(dbRoute, subIdList);
            if (paramMap.isEmpty()) continue;
            BizTypeUpgradeUtil.updateBiztypeData(dbRoute, paramMap);
            BizTypeUpgradeUtil.updateLinetypeData(dbRoute, paramMap);
            pProcessInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u6267\u884c\u7b2c{0}\u6279\u6b21\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"BizTypeUpgradeUtil_2", (String)"scm-mal-opplugin", (Object[])new Object[0]), pageIndex + 1)).append("\n");
        }
        if (!autoUpgrade) {
            logger.info(pProcessInfo.toString());
        }
        return true;
    }

    private static List<Object> getIdList(DBRoute dbRoute, String sqlAll, String idKey) {
        ArrayList<Object> idList = new ArrayList<Object>(500);
        try (DataSet totalData = BizTypeUpgradeUtil.queryDataSet(dbRoute, sqlAll);){
            totalData.forEach(rowx -> idList.add(rowx.getLong(idKey)));
        }
        return idList;
    }

    private static void updateBillTypeData(DBRoute dbRoute) {
        String sql = "update t_mal_order set fbilltypeid = 1317361223599179776";
        DB.execute((DBRoute)dbRoute, (String)sql);
    }

    private static void updateBiztypeData(DBRoute dbRoute, Map<String, List<Object[]>> paramMap) {
        List<Object[]> params = paramMap.get(BIZTYPE);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String sql = "update t_mal_order set fbusinesstypeid = ? where fid = ?";
        BizTypeUpgradeUtil.updateData(dbRoute, sql, params);
    }

    private static void updateLinetypeData(DBRoute dbRoute, Map<String, List<Object[]>> paramMap) {
        List<Object[]> params = paramMap.get(LINETYPE);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String sql = "update t_mal_orderentry set flinetypeid = ? where fentryid = ?";
        BizTypeUpgradeUtil.updateData(dbRoute, sql, params);
    }

    private static DataSet queryDataSet(DBRoute dbRoute, String sql) {
        return DB.queryDataSet((String)"MalBizTypeUpgradeOp.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, (Object[])null);
    }

    private static void updateData(DBRoute dbRoute, String updateSql, List<Object[]> params) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, params);
    }

    private static Map<String, List<Object[]>> getPmOrderPamraData(DBRoute dbRoute, List<Object> subIdList) {
        String entryIdSql = "select fentryid from t_mal_orderentry where fid in " + BizTypeUpgradeUtil.dealList(subIdList);
        ArrayList<Object> copyIdList = new ArrayList<Object>(subIdList);
        List<Object> subEntryIdList = BizTypeUpgradeUtil.getIdList(dbRoute, entryIdSql, "fentryid");
        String sql = "select A.fsrcbillentryid,A.fsrcbillid,B.flinetypeid,C.fbiztypeid from t_pm_purorderbillentry_r A inner join t_pm_purorderbillentry B on A.fentryid = B.fentryid left join t_pm_purorderbill C on A.fid = C.fid where A.fsrcbillentryid in " + BizTypeUpgradeUtil.dealList(subEntryIdList);
        HashMap<String, List<Object[]>> paramRes = new HashMap<String, List<Object[]>>(4);
        Map<Object, Object> rehandleParamResMap = new HashMap(4);
        HashMap bizTypeMap = new HashMap(500);
        ArrayList lineTypeParam = new ArrayList(500);
        try (DataSet totalData = BizTypeUpgradeUtil.queryDataSet(dbRoute, sql);){
            totalData.forEach(rowx -> {
                Object[] param = new Object[]{rowx.get("flinetypeid"), rowx.get("fsrcbillentryid")};
                lineTypeParam.add(param);
                bizTypeMap.put(rowx.getLong("fsrcbillid"), rowx.getLong("fbiztypeid"));
                copyIdList.remove(rowx.get("fsrcbillid"));
            });
        }
        if (!CollectionUtils.isEmpty(copyIdList)) {
            rehandleParamResMap = BizTypeUpgradeUtil.getMalOrderPamraData(dbRoute, copyIdList);
        }
        List lineTypeParamList = (List)rehandleParamResMap.get(LINETYPE);
        List bizTypeParamList = (List)rehandleParamResMap.get(BIZTYPE);
        if (!CollectionUtils.isEmpty((Collection)lineTypeParamList)) {
            lineTypeParam.addAll(lineTypeParamList);
        }
        if (!lineTypeParam.isEmpty()) {
            paramRes.put(LINETYPE, lineTypeParam);
        }
        ArrayList<Object[]> bizTypeParam = new ArrayList<Object[]>(bizTypeMap.size());
        for (Map.Entry entry : bizTypeMap.entrySet()) {
            Object[] biztypeParam = new Object[]{entry.getValue(), entry.getKey()};
            bizTypeParam.add(biztypeParam);
        }
        if (!CollectionUtils.isEmpty((Collection)bizTypeParamList)) {
            bizTypeParam.addAll(bizTypeParamList);
        }
        paramRes.put(BIZTYPE, bizTypeParam);
        return paramRes;
    }

    private static Map<String, List<Object[]>> getMalOrderPamraData(DBRoute dbRoute, List<Object> subIdList) {
        HashMap<String, List<Object[]>> paramRes = new HashMap<String, List<Object[]>>(4);
        String sql = "select A.fid,A.fentryid,B.fnumber,B.flinetype from t_mal_orderentry A inner join t_mal_extdata B on A.fpurtypeid = B.fid where A.fid in " + BizTypeUpgradeUtil.dealList(subIdList);
        HashMap purTypeMap = new HashMap(500);
        ArrayList lineTypeParamList = new ArrayList(500);
        ArrayList<Object[]> bizTypeParamList = new ArrayList<Object[]>(500);
        try (DataSet totalData = BizTypeUpgradeUtil.queryDataSet(dbRoute, sql);){
            totalData.forEach(rowx -> {
                Object[] param = new Object[]{rowx.get("flinetype"), rowx.get("fentryid")};
                lineTypeParamList.add(param);
                Set purTypeSet = purTypeMap.computeIfAbsent(rowx.getLong("fid"), s -> new HashSet());
                purTypeSet.add(rowx.getString("fnumber"));
            });
        }
        if (!lineTypeParamList.isEmpty()) {
            paramRes.put(LINETYPE, lineTypeParamList);
        }
        if (!purTypeMap.isEmpty()) {
            for (Map.Entry entry : purTypeMap.entrySet()) {
                Set purtypeSet = (Set)entry.getValue();
                Object[] biztypeParam = new Object[]{CollectionUtils.isEmpty((Collection)purtypeSet) || purtypeSet.size() > 1 ? Long.valueOf(422857170485263360L) : (StringUtils.equals((CharSequence)purtypeSet.toArray(new String[0])[0], (CharSequence)"PUR02_SYS") ? Long.valueOf(422860896797212672L) : (StringUtils.equals((CharSequence)purtypeSet.toArray(new String[0])[0], (CharSequence)"PUR04_SYS") ? Long.valueOf(744833764588533760L) : (StringUtils.equals((CharSequence)purtypeSet.toArray(new String[0])[0], (CharSequence)"PUR05_SYS") ? Long.valueOf(1305121047690920960L) : Long.valueOf(422857170485263360L)))), entry.getKey()};
                bizTypeParamList.add(biztypeParam);
            }
            paramRes.put(BIZTYPE, bizTypeParamList);
        }
        return paramRes;
    }

    private static String dealList(List<Object> subIdList) {
        List list = subIdList.stream().map(value -> {
            if (value instanceof String) {
                return "'" + String.valueOf(value) + "'";
            }
            return String.valueOf(value);
        }).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(String.join((CharSequence)",", list)).append(")");
        return stringBuilder.toString();
    }
}

