/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.mal.common.util.MalAddressUtil;

public class MalAddressSaveValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("address");
        set.add("phone");
        set.add("email");
        set.add("default");
        set.add("number");
        return set;
    }

    public void validate() {
        HashSet<Long> admindivisionIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject addressDyn = dataEntity.getDataEntity();
            admindivisionIdSet.add(addressDyn.getLong("address"));
        }
        DynamicObjectCollection admindivisionDyns = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname,level,country.number,country.twocountrycode", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)admindivisionIdSet.toArray(new Object[0]))});
        HashMap<Object, DynamicObject> admindivisionDynMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject admindivisionDyn : admindivisionDyns) {
            admindivisionDynMap.put(admindivisionDyn.get("id"), admindivisionDyn);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String email;
            String phone;
            DynamicObject addressDyn = dataEntity.getDataEntity();
            admindivisionIdSet.add(addressDyn.getLong("address"));
            DynamicObject admindivisionDyn = (DynamicObject)admindivisionDynMap.get(addressDyn.getLong("address"));
            if (admindivisionDyn == null) continue;
            int level = admindivisionDyn.getInt("level");
            String fullName = admindivisionDyn.getString("fullname");
            if (level < 3 && ("001".equals(admindivisionDyn.getString("country.number")) || "CN".equals(admindivisionDyn.getString("country.twocountrycode")))) {
                if (MalAddressUtil.isMunicipality((String)fullName)) {
                    if (level < 2) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u201c\u7701\u5e02\u533a\u201d\u3002", (String)"MalAddressSaveValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u201c\u7701\u5e02\u533a\u201d\u3002", (String)"MalAddressSaveValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                }
            } else if (level < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u201c\u7701\u5e02\u533a\u201d\u3002", (String)"MalAddressSaveValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)(phone = addressDyn.getString("phone"))) && !ValidateMatchUtil.isTel((String)phone) && !StringUtils.isPhoneNumberValid((String)phone)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u586b\u5199\u7684\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"MalAddressSaveValidator_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)(email = addressDyn.getString("email"))) && !ValidateMatchUtil.isEmail((String)email)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"MalAddressSaveValidator_2", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            boolean isDefault = addressDyn.getBoolean("default");
            QFilter filter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId()).and("default", "=", (Object)true).and("number", "!=", (Object)addressDyn.getString("number"));
            Map defaultAddressDynMap = BusinessDataServiceHelper.loadFromCache((String)"mal_address", (String)"default,number", (QFilter[])new QFilter[]{filter});
            if (!isDefault && defaultAddressDynMap.size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u4e00\u4e2a\u9ed8\u8ba4\u5730\u5740\u3002", (String)"MalAddressSaveValidator_3", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            if (!isDefault || addressDyn.getBoolean("enable")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5730\u5740\u5df2\u7981\u7528\uff0c\u4e0d\u53ef\u8bbe\u4e3a\u9ed8\u8ba4\u5730\u5740\u3002", (String)"MalAddressSaveValidator_4", (String)"scm-mal-opplugin", (Object[])new Object[0]));
        }
    }
}

