/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;

public class MalGoodsStatusValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("receipt.address.id");
        set.add("platform");
        set.add("goods.id");
        set.add("deporg.id");
        set.add("qty");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            ArrayList<String> goodsNumber = new ArrayList<String>(entryCol.size());
            for (DynamicObject entry : entryCol) {
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrderDyn.getString("platform"))) continue;
                goodsNumber.add(entry.getString("goods.number"));
            }
            if (goodsNumber.isEmpty()) {
                return;
            }
            List invalidProdNumbers = MalPlaceOrderUtils.checkSkuStates((String)malOrderDyn.getString("platform"), goodsNumber);
            if (invalidProdNumbers.isEmpty()) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u90e8\u5206\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002 \n\u5546\u54c1\u7f16\u7801\uff1a{0}", (String)"MalGoodsStatusValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{MalProductUtil.formatProdNumber((List)invalidProdNumbers)}));
        }
    }
}

