/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

public class MalMaterialAndPurTypeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("platform");
        set.add("entryentity.material");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            boolean isGoodsBizType = MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)malOrderDyn.getDynamicObject("businesstype"));
            HashSet<Long> repeatPurtypeIdSet = new HashSet<Long>();
            for (DynamicObject entry : entryCol) {
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrderDyn.getString("platform"))) {
                    repeatPurtypeIdSet.add(entry.getLong("purtype_id"));
                }
                DynamicObject materialDyn = entry.getDynamicObject("material");
                DynamicObject purtypeDyn = entry.getDynamicObject("purtype");
                if (Objects.isNull(materialDyn) || purtypeDyn == null || !materialDyn.containsProperty("serviceattribute") || isGoodsBizType) continue;
                Set serviceAttrIdSet = MalPlaceOrderUtils.getServiceAttrIdSetByMaterial((DynamicObject)materialDyn);
                Long serviceAttrIdByPurType = this.getServiceAttrByPurType(purtypeDyn);
                if (serviceAttrIdSet.isEmpty() && serviceAttrIdByPurType == 0L || serviceAttrIdSet.contains(serviceAttrIdByPurType)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u4e0e{1}\u5173\u7cfb\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6b63\u786e\u7ef4\u62a4\u7269\u6599\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0e\u91c7\u8d2d\u7c7b\u578b\u4e2d\u884c\u7c7b\u578b\u5173\u8054\u7684\u4e1a\u52a1\u5c5e\u6027\u3002", (String)"MalMaterialAndPurTypeValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{materialDyn.getString("name"), purtypeDyn.getString("name")}));
            }
            if (repeatPurtypeIdSet.size() <= 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e00\u4e2a\u7535\u5546\u8ba2\u5355\u53ea\u652f\u6301\u4e00\u79cd\u91c7\u8d2d\u7c7b\u578b\uff0c\u8bf7\u4fee\u6539\u91c7\u8d2d\u7c7b\u578b\u6216\u91cd\u9009\u5546\u54c1\u3002", (String)"MalMaterialAndPurTypeValidator_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
        }
    }

    private Long getServiceAttrByPurType(DynamicObject purTypeDyn) {
        DynamicObject lineType;
        Object lineTypeId;
        if (purTypeDyn != null && (lineTypeId = purTypeDyn.get("linetype.id")) != null && (lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype")) != null) {
            return lineType.getLong("serviceattribute.id");
        }
        return 0L;
    }
}

