/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class MalOrderQtyValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("qty");
        propertys.add("platform");
        propertys.add("goods.number");
        return propertys;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            String platform = dataEntity.getDataEntity().getString("platform");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) continue;
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            ArrayList<String> goodsNumbers = new ArrayList<String>();
            for (DynamicObject entry : entryCol) {
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty.compareTo(new BigDecimal(qty.toBigInteger().toString())) == 0) continue;
                goodsNumbers.add(entry.getString("goods.number"));
            }
            if (goodsNumbers.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7535\u5546\u5546\u54c1\u4e0b\u5355\u6570\u91cf\u4e0d\u652f\u6301\u5c0f\u6570\uff0c\u8bf7\u4fee\u6539\u3002\u5546\u54c1\u7f16\u7801\uff1a{0}", (String)"MalOrderQtyValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{StringUtils.join((Object[])goodsNumbers.toArray(), (String)",")}));
        }
    }
}

