/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;

public class MalOrderSubmitValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(this.dataEntities.length * 16);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, List> goodsIdAndDynMap = new HashMap<Long, List>(dataEntities.length);
        HashMap<Long, GoodsInventoryHandleSku> goodsIdAndQtyMap = new HashMap<Long, GoodsInventoryHandleSku>(dataEntities.length);
        ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dataEntities.length);
        for (ExtendedDataEntity dyn : dataEntities) {
            DynamicObject dataEntity = dyn.getDataEntity();
            long depOrgId = dataEntity.getLong("deporg.id");
            if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(dataEntity.getString("platform")) || !BillStatusEnum.SAVE.getVal().equals(dataEntity.getString("billstatus"))) continue;
            for (DynamicObject entry : dataEntity.getDynamicObjectCollection("entryentity")) {
                MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.buildGeneralParam((Long)entry.getLong("goods_id"), (String)dataEntity.getString("platform"), (BigDecimal)entry.getBigDecimal("qty"), (String)dataEntity.getString("receipt.address.id"), (Long)depOrgId);
                malMatGoodsInitParams.add(malMatGoodsInitParam);
                long goodsId = entry.getLong("goods_id");
                GoodsInventoryHandleSku sku = goodsIdAndQtyMap.getOrDefault(goodsId, new GoodsInventoryHandleSku());
                List extendedDataEntities = goodsIdAndDynMap.computeIfAbsent(goodsId, k -> new ArrayList());
                sku.setGoodsId(Long.valueOf(goodsId));
                sku.setGoodsNumber(entry.getDynamicObject("goods").getString("number"));
                sku.setQty(sku.getQty().add(entry.getBigDecimal("qty")));
                skuList.add(sku);
                extendedDataEntities.add(dyn);
                goodsIdAndQtyMap.put(goodsId, sku);
            }
        }
        if (!malMatGoodsInitParams.isEmpty()) {
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
            if (!MalOrderParamUtil.isSelfInventoryUnlimited() && MalOrderParamUtil.getDefaultMalVersion()) {
                List goodsInventories = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"queryGoodsInventory", (Object[])new Object[]{skuList});
                for (GoodsInventory goodsInventory : goodsInventories) {
                    GoodsInventoryHandleSku sku = (GoodsInventoryHandleSku)goodsIdAndQtyMap.get(goodsInventory.getGoodsId());
                    BigDecimal availableQty = goodsInventory.getAvailableQty();
                    if (goodsInventory.isUnlimited() || sku.getQty().compareTo(availableQty) <= 0) continue;
                    List extendedDataEntityList = (List)goodsIdAndDynMap.get(goodsInventory.getGoodsId());
                    extendedDataEntityList.forEach(extendedDataEntity -> this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u5e93\u5b58\u4e0d\u8db3\u3002", (String)"MalOrderSubmitValidator_2", (String)"scm-mal-opplugin", (Object[])new Object[]{sku.getGoodsNumber()})));
                }
            }
            for (ExtendedDataEntity dyn : dataEntities) {
                String strMsg;
                if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(dyn.getDataEntity().getString("platform"))) continue;
                long deptId = dyn.getDataEntity().getDynamicObject("deporg").getLong("id");
                DynamicObjectCollection malOrderEntryCol = dyn.getDataEntity().getDynamicObjectCollection("entryentity");
                ArrayList<String> invalidMallStatusGoodsNumbers = new ArrayList<String>(malOrderEntryCol.size());
                ArrayList<String> invalidMinOrderQtyGoodsNumbers = new ArrayList<String>(malOrderEntryCol.size());
                for (DynamicObject entryDyn : malOrderEntryCol) {
                    MalGoods malGoods = (MalGoods)malGoodsMap.get(entryDyn.getLong("goods.id"));
                    if (malGoods == null) continue;
                    if (!malGoods.validateMallStatus() || !malGoods.isGoodsVisible() && !malGoods.getApplicableOrgSet().contains(deptId)) {
                        invalidMallStatusGoodsNumbers.add(malGoods.getNumber());
                    }
                    BigDecimal qty = entryDyn.getBigDecimal("qty");
                    if (malGoods.getMinOrderQty() == null || malGoods.getMinOrderQty().compareTo(qty) <= 0) continue;
                    invalidMinOrderQtyGoodsNumbers.add(malGoods.getNumber());
                }
                if (!invalidMallStatusGoodsNumbers.isEmpty()) {
                    strMsg = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1{0}\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\u6216\u5728\u7533\u8bf7\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalOrderSubmitValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", invalidMallStatusGoodsNumbers)});
                    this.addErrorMessage(dyn, strMsg);
                }
                if (invalidMinOrderQtyGoodsNumbers.isEmpty()) continue;
                strMsg = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1{0}\u7684\u91c7\u8d2d\u6570\u91cf\u672a\u8fbe\u8d77\u8ba2\u91cf\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalOrderSubmitValidator_1", (String)"scm-mal-opplugin", (Object[])new Object[]{String.join((CharSequence)"\uff0c", invalidMinOrderQtyGoodsNumbers)});
                this.addErrorMessage(dyn, strMsg);
            }
        }
    }
}

