/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.mal.opplugin.util.MalOrderUtil;

public class MalOrderValidator
extends AbstractValidator {
    private static String PROCESSING = "A";

    public void validate() {
        String ismsg;
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String entrIdListStr = (String)paramMap.get("entryIds");
        List entrIdList = new ArrayList(16);
        if (!StringUtils.isEmpty((CharSequence)entrIdListStr)) {
            entrIdList = (List)SerializationUtils.fromJsonString((String)entrIdListStr, List.class);
        }
        if (!StringUtils.isEmpty((CharSequence)(ismsg = (String)paramMap.get("ismsg")))) {
            return;
        }
        Map<String, DynamicObject> purOrderStatusMap = MalOrderUtil.getPurOrderBillDynMap(this.dataEntities);
        HashSet<String> billnos = new HashSet<String>(1024);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyo = dataEntity.getDataEntity();
            String state = dyo.getString("billstatus");
            if (!StringUtils.equalsIgnoreCase((CharSequence)BillStatusEnum.AUDIT.getVal(), (CharSequence)state)) continue;
            billnos.add(dyo.getString("billno"));
        }
        HashMap<String, DynamicObject> billno_LogInfos = new HashMap<String, DynamicObject>(1024);
        boolean defaultMalVersion = kd.scm.common.util.MalOrderUtil.getDefaultMalVersion();
        if (defaultMalVersion && billnos.size() > 0) {
            DynamicObjectCollection logDyCol = QueryServiceHelper.query((String)"bos_log_asyncop", (String)"exetime,entity,consume,billno,log_tag,success", (QFilter[])new QFilter[]{new QFilter("billno", "in", billnos)}, (String)"exetime desc");
            for (DynamicObject info : logDyCol) {
                Date exetime = info.getDate("exetime");
                String billno = info.getString("billno");
                if (null == billno_LogInfos.get(billno)) {
                    billno_LogInfos.put(billno, info);
                    continue;
                }
                DynamicObject oldInfo = (DynamicObject)billno_LogInfos.get(billno);
                Date oldExetime = oldInfo.getDate("exetime");
                if (!exetime.after(oldExetime)) continue;
                billno_LogInfos.put(billno, info);
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object entryDyo2;
            StringBuilder errorMsg = new StringBuilder();
            DynamicObject dyo = dataEntity.getDataEntity();
            String state = dyo.getString("billstatus");
            if (!StringUtils.equalsIgnoreCase((CharSequence)BillStatusEnum.AUDIT.getVal(), (CharSequence)state)) continue;
            DynamicObjectCollection dyoCol = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            HashSet<String> tarBillnos = new HashSet<String>(16);
            for (Object entryDyo2 : dyoCol) {
                DynamicObject logInfo;
                if (entrIdList.size() > 0 && !entrIdList.contains(entryDyo2.getString("id"))) continue;
                String purBillNo = entryDyo2.getString("erpbillnumber");
                DynamicObject purBill = purOrderStatusMap.get(purBillNo);
                if (purBill != null) {
                    String purBillStatus = purBill.getString("billstatus");
                    String cfmStatus = purBill.getString("cfmstatus");
                    if ((!StringUtils.equalsIgnoreCase((CharSequence)BillStatusEnum.AUDIT.getVal(), (CharSequence)purBillStatus) || StringUtils.equalsIgnoreCase((CharSequence)cfmStatus, (CharSequence)ConfirmStatusEnum.UNCONFIRM.getVal())) && !StringUtils.equalsIgnoreCase((CharSequence)BillStatusEnum.CLOSED.getVal(), (CharSequence)purBillStatus) && !StringUtils.equalsIgnoreCase((CharSequence)BillStatusEnum.CHANGED.getVal(), (CharSequence)purBillStatus)) continue;
                    tarBillnos.add(purBillNo);
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)purBillNo)) continue;
                String billno = dyo.getString("billno");
                if (!defaultMalVersion || null == billno_LogInfos.get(billno) || ((logInfo = (DynamicObject)billno_LogInfos.get(billno)).getBoolean("consume") || logInfo.getBoolean("success")) && (!logInfo.getBoolean("consume") || !logInfo.getBoolean("success"))) continue;
                errorMsg.append(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u91c7\u8d2d\u8ba2\u5355\u6b63\u5728\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u8ba2\u5355\u3002", (String)"MalOrderValidator_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
                this.addErrorMessage(dataEntity, errorMsg.toString());
                return;
            }
            if (tarBillnos.size() <= 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            entryDyo2 = tarBillnos.iterator();
            while (entryDyo2.hasNext()) {
                String billno = (String)entryDyo2.next();
                stringBuilder.append(billno).append('\u3001');
            }
            if (stringBuilder.length() <= 0) continue;
            String billnoStr = stringBuilder.substring(0, stringBuilder.length() - 1);
            String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\uff1a{0}\u5df2\u88ab\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u8ba2\u5355\u3002", (String)"MalOrderValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{billnoStr});
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

