/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.org.MalOrgServiceFactory;

public class MalOrgValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("platform");
        set.add("businesstype");
        set.add("deporg");
        set.add("rcvorg");
        set.add("settleorg");
        set.add("org");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            DynamicObject bizType = malOrderDyn.getDynamicObject("businesstype");
            if (!MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)bizType)) continue;
            DynamicObject depDyo = malOrderDyn.getDynamicObject("deporg");
            if (!OrgUnitServiceHelper.checkOrgFunction((Long)depDyo.getLong("id"), (String)"01")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u7ec4\u7ec7\u4e0d\u662f\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MalOrgValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            if (!MalOrgServiceFactory.hasDelegantRalation()) continue;
            DynamicObject invOrg = malOrderDyn.getDynamicObject("rcvorg");
            DynamicObject pursettleOrg = malOrderDyn.getDynamicObject("settleorg");
            DynamicObject purOrg = malOrderDyn.getDynamicObject("org");
            long purToSetOrgId = 0L;
            long invToSettOrgId = 0L;
            List purToSetIdList = new ArrayList();
            List invToSettIdList = new ArrayList();
            if (null != purOrg) {
                purToSetIdList = OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)purOrg.getLong("id"));
                long l = purToSetOrgId = purToSetIdList.size() > 0 ? (Long)purToSetIdList.get(0) : 0L;
            }
            if (null != invOrg) {
                invToSettIdList = OrgUtil.getToOrg((String)OrgTypeEnum.INVENTORY.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)invOrg.getLong("id"));
                long l = invToSettOrgId = invToSettIdList.size() > 0 ? (Long)invToSettIdList.get(0) : 0L;
            }
            if (purToSetIdList.size() < 1 || invToSettIdList.size() < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u6216\u5e93\u5b58\u7ec4\u7ec7\u672a\u59d4\u6258\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u59d4\u6258\u5173\u7cfb\u3002", (String)"MalOrgValidator_1", (String)"scm-mal-opplugin", (Object[])new Object[0]));
            }
            if (pursettleOrg.getLong("id") == purToSetOrgId || pursettleOrg.getLong("id") == invToSettOrgId) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u516c\u53f8\u4e0e\u91c7\u8d2d\u7ec4\u7ec7\u3001\u6536\u8d27\u7ec4\u7ec7\u7684\u5173\u7cfb\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u6838\u7b97\u516c\u53f8\u3002", (String)"MalOrgValidator_2", (String)"scm-mal-opplugin", (Object[])new Object[0]));
        }
    }
}

