/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;

public class MalPurSchemeToOrderValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("goods.source");
        set.add("goods.id");
        set.add("goods.number");
        set.add("qty");
        return set;
    }

    public void validate() {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(32);
        OperateOption option = this.getOption();
        HashSet<Object> selectedGoodsIdsSet = new HashSet();
        if (option.containsVariable("selectedGoodsIds")) {
            String selectedGoodsIds = option.getVariableValue("selectedGoodsIds");
            String[] selectedGoodsIdsArr = selectedGoodsIds.split(",");
            selectedGoodsIdsSet = new HashSet<String>(Arrays.asList(selectedGoodsIdsArr));
        }
        for (ExtendedDataEntity extDyn : this.getDataEntities()) {
            DynamicObjectCollection entryCol = extDyn.getDataEntity().getDynamicObjectCollection("goodsentry");
            for (DynamicObject entry : entryCol) {
                DynamicObject goodsDyn = entry.getDynamicObject("goods");
                if (goodsDyn == null || !selectedGoodsIdsSet.isEmpty() && !selectedGoodsIdsSet.contains(goodsDyn.getString("id"))) continue;
                String source = goodsDyn.getString("source");
                Long goodsId = goodsDyn.getLong("id");
                String goodsNumber = goodsDyn.getString("number");
                malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)goodsNumber, (String)source, (BigDecimal)entry.getBigDecimal("qty"), (String)"", (Long)RequestContext.get().getOrgId()));
            }
        }
        if (!malMatGoodsInitParams.isEmpty()) {
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)true, (boolean)false);
            MalPlaceOrderValidateResult malPlaceOrderValidateResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).validateGoodsForPlaceOrder(new HashMap(), malGoodsMap, false, RequestContext.get().getOrgId());
            if (!malPlaceOrderValidateResult.getErrorInfos().isEmpty()) {
                throw new KDBizException(String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()));
            }
        }
    }
}

