/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.MalFeeHandleHelper;

public class MalSaleableValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("receipt.address.longnumber");
        set.add("goods.number");
        set.add("platform");
        set.add("receipt");
        return set;
    }

    public void validate() {
        ArrayList<Long> goodsList = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equalsIgnoreCase(malOrderDyn.getString("platform"))) continue;
            for (DynamicObject entry : entryCol) {
                goodsList.add(entry.getLong("goods_id"));
            }
        }
        if (goodsList.isEmpty()) {
            return;
        }
        HashMap<Long, List> supplierIdToSkuListMap = new HashMap<Long, List>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject malOrderDyn = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            String addressLongnumber = this.getAddressLongnumber(malOrderDyn);
            for (DynamicObject entry : entryCol) {
                long supplierId = entry.getLong("supplier_id");
                List skuList = supplierIdToSkuListMap.getOrDefault(supplierId, new ArrayList());
                skuList.add(entry.getString("goods.number"));
                supplierIdToSkuListMap.put(supplierId, skuList);
            }
            List<Long> unSaleableSupplierIdList = this.checkShippingArea(supplierIdToSkuListMap.keySet(), addressLongnumber);
            for (Long unSaleableSupplierId : unSaleableSupplierIdList) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u90e8\u5206\u5546\u54c1\u5728\u5f53\u524d\u533a\u57df\u4e0d\u53ef\u552e\uff0c\u5546\u54c1\u7f16\u7801\u4e3a{0}\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalSaleableValidator_0", (String)"scm-mal-opplugin", (Object[])new Object[]{StringUtils.join((Object[])((List)supplierIdToSkuListMap.get(unSaleableSupplierId)).toArray(), (String)",")}));
            }
        }
    }

    private String getAddressLongnumber(DynamicObject malOrderDyn) {
        DynamicObject receiptDyn;
        DynamicObject admindivisionDyn;
        Object receiptDynObj = malOrderDyn.get("receipt");
        if (receiptDynObj instanceof DynamicObject && (admindivisionDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf((receiptDyn = (DynamicObject)receiptDynObj).getString("address")), (String)"bd_admindivision")) != null) {
            return admindivisionDyn.getString("longnumber");
        }
        return "";
    }

    private List<Long> checkShippingArea(Set<Long> supplierIds, String addressLongnumber) {
        ArrayList<Long> res = new ArrayList<Long>();
        QFilter freightFilter = new QFilter("supplier.id", "in", supplierIds);
        String freightFields = "supplier.id,supplier.number,national,entryentity.longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"ent_freightscheme", (String)freightFields, (QFilter[])new QFilter[]{freightFilter}, null);){
            for (Row row : ds) {
                String entryLongNum;
                if (row.getBoolean("national").booleanValue() || !StringUtils.isBlank((CharSequence)(entryLongNum = row.getString("entryentity.longnumber"))) && MalFeeHandleHelper.maxLenOfLCString((String)addressLongnumber, (String)entryLongNum) > 3) continue;
                res.add(row.getLong("supplier.id"));
            }
        }
        return res;
    }
}

