/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extplugin.PluginFilter;
import kd.bos.extplugin.PluginProxy;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.sdk.MaterialGroupStandardDefService;
import kd.scm.common.sdk.SupplierGroupStandardDefService;
import kd.sdk.scm.common.extpoint.IMaterialGroupStandardService;
import kd.sdk.scm.common.extpoint.ISupplierGroupStandardService;

public class GroupStandardUtils {
    public static Set<Long> getGroupOrgId(String entity, Set<Long> useOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<Object> numberSets = new HashSet<Object>();
        ORM ormOv = ORM.create();
        if (ctrlview != null) {
            try (DataSet ds = ormOv.queryDataSet(GroupStandardUtils.class.getName(), "bos_org_structure", "longnumber,org", new QFilter[]{new QFilter("org", "in", useOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong("id"))});){
                for (Row d : ds) {
                    String longnumber = d.getString("longnumber");
                    String[] numbers = longnumber.split("!");
                    numberSets.addAll(Arrays.asList((Object[])numbers.clone()));
                }
            }
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        if (numberSets.size() > 0) {
            DataSet ds = ormOv.queryDataSet(GroupStandardUtils.class.getName(), "bos_org", "id", new QFilter[]{new QFilter("number", "in", numberSets)});
            Object object = null;
            try {
                for (Row d : ds) {
                    orgIds.add(d.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return orgIds;
    }

    public static Set<Long> getCreateOrgs(ListShowParameter param, String entityName, String useOrgId) {
        String createOrg = null;
        HashSet<Long> createOrgs = null;
        if (param.isLookUp()) {
            long createOrgId;
            Map customParams = param.getCustomParams();
            List col = (List)customParams.get("useOrgs");
            if (col != null && !col.isEmpty()) {
                createOrgs = new HashSet(col);
            }
            if (StringUtils.isBlank((CharSequence)(createOrg = (String)customParams.get("useOrg"))) && (createOrgId = param.getUseOrgId()) != 0L) {
                createOrg = createOrgId + "";
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)useOrgId)) {
                createOrg = useOrgId;
            }
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                String appNumber = param.getAppId();
                createOrg = GroupStandardUtils.getDefaultUseOrg(GroupStandardUtils.getMasterDataOrg(entityName, appNumber));
            }
        }
        if (createOrgs == null || createOrgs.isEmpty()) {
            createOrgs = new HashSet<Long>();
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                return createOrgs;
            }
            createOrgs.add(Long.valueOf(createOrg));
        }
        return createOrgs;
    }

    public static DynamicObjectCollection getMasterDataOrg(String entityType, String appNumber) {
        QFilter extendOrgQFilter;
        String orgFuncPro;
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appNumber, (String)entityType, (String)"47150e89000000ac");
        if (result == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityType);
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        String view = "";
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new DynamicObjectCollection();
        }
        for (DynamicObject viewOrg : viewOrgs) {
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter("id", "in", viewOrgIds);
        filterList.add(idsFilter);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
        filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters);
        return col;
    }

    private static String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        long longinOrg = RequestContext.get().getOrgId();
        boolean flag = false;
        if (col != null && col.size() > 0) {
            for (DynamicObject row : col) {
                if (longinOrg != row.getLong("id")) continue;
                defaultUseOrg = String.valueOf(longinOrg);
                flag = true;
                break;
            }
            return flag ? defaultUseOrg : String.valueOf(((DynamicObject)col.get(0)).get("id"));
        }
        return defaultUseOrg;
    }

    public static Long getDataByType(Object object) {
        Long dataId = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject baseData = (DynamicObject)object;
            dataId = (Long)baseData.getPkValue();
        } else if (object instanceof Long) {
            dataId = (Long)object;
        }
        return dataId;
    }

    public static Long getMaterialGroupType(String appid) {
        MaterialGroupStandardDefService defPlugin = new MaterialGroupStandardDefService();
        Long[] groupStandarIds = new Long[1];
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, IMaterialGroupStandardService.class, (String)"SCM_SETMATERIALGROUPSTANDARD_EXT", (PluginFilter)null);
        pluginProxy.callReplaceIfPresent(p -> {
            groupStandarIds[0] = p.getMaterialGroupStandard(appid);
            return null;
        });
        return groupStandarIds[0] == null ? BillAssistConstant.MATERIAL_STANDARD_ID : groupStandarIds[0];
    }

    public static Long getSupplierGroupType() {
        SupplierGroupStandardDefService defPlugin = new SupplierGroupStandardDefService();
        Long[] groupStandarIds = new Long[1];
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISupplierGroupStandardService.class, (String)"SCM_SETSUPPLIERGROUPSTANDARD_EXT", (PluginFilter)null);
        pluginProxy.callReplaceIfPresent(p -> {
            groupStandarIds[0] = p.getSupplierGroupStandard();
            return null;
        });
        return groupStandarIds[0] == null ? BillAssistConstant.GROUP_STANDARD_ID : groupStandarIds[0];
    }

    public static Map<? extends Long, ? extends Set<Long>> getGroupOrgMap(String entity, Set<Long> createOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        QFilter ctrlviewQf = null;
        ctrlviewQf = ctrlview != null ? new QFilter("view.id", "=", (Object)ctrlview.getLong("id")) : new QFilter("1", "=", (Object)1);
        HashSet<Object> numberSets = new HashSet<Object>();
        HashMap<String, Long> numberToCreateOrg = new HashMap<String, Long>();
        HashMap<Long, HashSet<Long>> resultMap = new HashMap<Long, HashSet<Long>>();
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(GroupStandardUtils.class.getName(), "bos_org_structure", "longnumber,org", new QFilter[]{new QFilter("org", "in", createOrgs), ctrlviewQf});){
            for (Row d : ds) {
                String longnumber = d.getString("longnumber");
                String[] numbers = longnumber.split("!");
                numberSets.addAll(Arrays.asList((Object[])numbers.clone()));
                for (String number : numbers) {
                    numberToCreateOrg.put(number, d.getLong("org"));
                }
            }
        }
        if (numberSets.size() > 0) {
            ds = ormOv.queryDataSet(GroupStandardUtils.class.getName(), "bos_org", "id,number", new QFilter[]{new QFilter("number", "in", numberSets)});
            var9_9 = null;
            try {
                for (Row d : ds) {
                    Long createOrgId = (Long)numberToCreateOrg.get(d.getString("number"));
                    if (createOrgId == null) continue;
                    HashSet<Long> orgIdList = (HashSet<Long>)resultMap.get(createOrgId);
                    if (orgIdList == null) {
                        orgIdList = new HashSet<Long>();
                        resultMap.put(createOrgId, orgIdList);
                    }
                    orgIdList.add(d.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var9_9 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return resultMap;
    }

    public static Map<Long, Long> getMaterialToGroupInStd(Set<Long> materialSets, String entity) {
        HashMap<Long, Long> materialGroupMap = new HashMap<Long, Long>(materialSets.size());
        if (materialSets != null) {
            QFilter mQfilter = new QFilter("material", "in", materialSets);
            mQfilter.and("standard", "=", (Object)GroupStandardUtils.getMaterialGroupType(entity));
            Map materialGroupDetails = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"standard,group,createorg,material", (QFilter[])new QFilter[]{mQfilter});
            for (DynamicObject value : materialGroupDetails.values()) {
                Long material = GroupStandardUtils.getDataByType(value.get("material"));
                Long group = GroupStandardUtils.getDataByType(value.get("group"));
                materialGroupMap.put(material, group);
            }
        }
        return materialGroupMap;
    }
}

