/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.mcm.common.StrategyMapConstant;

public class StrategyLayDownHelper {
    private static Log log = LogFactory.getLog(StrategyLayDownHelper.class);

    public static void doPushAndShow(IFormView view, String sourceEntityNumber, String targetEntityNumber, String operateKey, Set<Object> ids) {
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(16);
        for (Object id : ids) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(id);
            selectedRowList.add(listSelectedRow);
        }
        StrategyLayDownHelper.doPushAndShowByEntry(view, sourceEntityNumber, targetEntityNumber, operateKey, selectedRowList);
    }

    public static void doPushAndShowByEntry(IFormView view, String sourceEntityNumber, String targetEntityNumber, String operateKey, List<ListSelectedRow> selectedRowList) {
        if (view == null) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(true);
        pushArgs.setSelectedRows(selectedRowList);
        String targetPlan = StrategyLayDownHelper.getTargetPlan(sourceEntityNumber);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"change") && StringUtils.isNotBlank((CharSequence)targetPlan)) {
            ArrayList<Object> primaryKeys = new ArrayList<Object>(1);
            for (ListSelectedRow listSelectedRow : selectedRowList) {
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                primaryKeys.add(primaryKeyValue);
            }
            if (StrategyLayDownHelper.isAllJobPass(view, primaryKeys, targetPlan)) {
                return;
            }
            if (StrategyLayDownHelper.hasPlanChangeBill(view, primaryKeys, targetPlan)) {
                return;
            }
        }
        try {
            ConvertOperationResult convertResult;
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushplan")) {
                pushArgs.getCustomParams().put("targetEntity", targetEntityNumber);
                convertResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            } else {
                convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            if (convertResult.isSuccess() && convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() != 0) {
                if (convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() == 1) {
                    if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushplan")) {
                        StrategyLayDownHelper.showTargetBill(view, pushArgs, convertResult, operateKey);
                    }
                } else if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"pushplan")) {
                    Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\u3002", (String)"StrategyLayDownHelper_1", (String)"scm-mcm", (Object[])new Object[0]));
                if (view instanceof ListView) {
                    ((ListView)view).refresh();
                } else {
                    view.updateView();
                }
            } else {
                List billReports = convertResult.getBillReports();
                StringBuilder sbBuilder = new StringBuilder();
                for (SourceBillReport billReport : billReports) {
                    String failMessage = billReport.getFailMessage();
                    sbBuilder.append(failMessage);
                }
                if (StringUtils.isNotBlank((CharSequence)convertResult.getMessage())) {
                    sbBuilder.append(convertResult.getMessage());
                }
                if (StringUtils.isNotBlank((CharSequence)sbBuilder.toString())) {
                    view.showTipNotification(sbBuilder.toString());
                } else {
                    Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
                }
            }
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u518d\u6b21\u6267\u884c\u3002", (String)"StrategyLayDownHelper_0", (String)"scm-mcm", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private static boolean hasPlanChangeBill(IFormView view, List<Object> primaryKeys, String targetPlan) {
        String changeBillByPlan = StrategyMapConstant.getChangeBillByPlan(targetPlan);
        QFilter qFilter = QFilter.join((String)"planid", (String)(targetPlan + ".id"), (QFilter)new QFilter(targetPlan + ".sourcebill", "in", primaryKeys), (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)true);
        QFilter qFilter1 = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
        qFilter1.and(qFilter);
        DynamicObject info = QueryServiceHelper.queryOne((String)changeBillByPlan, (String)"id,planid,version", (QFilter[])new QFilter[]{qFilter1});
        if (info != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5236\u5b9a\u5355\u5b58\u5728\u5728\u9014\u7684\u8ba1\u5212\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"StrategyLayDownHelper_3", (String)"scm-mcm", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAllJobPass(IFormView view, List<Object> primaryKeys, String targetPlan) {
        String jobEntity = StrategyLayDownHelper.getJobByPlan(targetPlan);
        QFilter qFilter = new QFilter("strategyid", "in", primaryKeys);
        DynamicObjectCollection billstatus = QueryServiceHelper.query((String)jobEntity, (String)"billstatus", (QFilter[])new QFilter[]{qFilter});
        boolean flag = true;
        if (billstatus.size() > 0) {
            for (DynamicObject row : billstatus) {
                String status = row.getString("billstatus");
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)status) && !StringUtils.equals((CharSequence)"B", (CharSequence)status)) continue;
                flag = false;
                break;
            }
            if (flag) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u4efb\u52a1\u7684\u4efb\u52a1\u72b6\u6001\u5168\u90e8\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u7b56\u7565\u53d8\u66f4\u3002", (String)"StrategyLayDownHelper_2", (String)"scm-mcm", (Object[])new Object[0]));
                return flag;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    private static void showTargetBill(IFormView view, PushArgs pushArgs, ConvertOperationResult convertResult, String operateKey) {
        if (view == null) {
            return;
        }
        Object showParameter = null;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        boolean isBasedata = mainType instanceof BasedataEntityType;
        showParameter = isBasedata ? new BaseShowParameter() : new BillShowParameter();
        showParameter.setFormId(convertResult.loadTargetLayoutFormId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (convertResult.getTargetBillIds().isEmpty()) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCachePageId((String)convertResult.getCachePageIds().get(0));
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId(convertResult.getTargetBillIds().iterator().next());
        }
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        showParameter.getCustomParams().put("botptag_of_datasource", String.valueOf(true));
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        showParameter.getCustomParams().put("showreport", String.valueOf(false));
        if (StringUtils.isNotBlank((CharSequence)pushArgs.getAppId())) {
            showParameter.getCustomParams().put("checkRightAppId", pushArgs.getAppId());
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("ConvertOperationResult", resultJson);
        showParameter.getCustomParams().put(operateKey, operateKey);
        view.showForm((FormShowParameter)showParameter);
    }

    public static String getTargetPlan(String srcEntity) {
        switch (srcEntity) {
            case "mcm_supplylayout": {
                return "mcm_supply_plan";
            }
            case "mcm_performimpove": {
                return "mcm_improve_plan";
            }
            case "mcm_differentiation": {
                return "mcm_differentiation_plan";
            }
            case "mcm_supplyrate": {
                return "mcm_supplyrate_plan";
            }
            case "mcm_reduce": {
                return "mcm_reduce_plan";
            }
        }
        return "";
    }

    public static String getLayoutByPlan(String entity) {
        switch (entity) {
            case "mcm_supply_plan": {
                return "mcm_supplylayout";
            }
            case "mcm_improve_plan": {
                return "mcm_performimpove";
            }
            case "mcm_differentiation_plan": {
                return "mcm_differentiation";
            }
            case "mcm_reduce_plan": {
                return "mcm_reduce";
            }
        }
        return "";
    }

    public static ListShowParameter createShowParameter(String entityNumber, QFilter qFilter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setShowFilter(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        showParameter.getCustomParams().put("isfromreport", "true");
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setHasRight(true);
        return showParameter;
    }

    public static void attToAttachmentFile(List<Map<String, Object>> attachments, DynamicObjectCollection attCol) {
        ORM orm = ORM.create();
        for (Map<String, Object> map : attachments) {
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            attObj.set("name", map.get("name"));
            attObj.set("size", map.get("size"));
            attObj.set("uid", (Object)("rc-upload-" + UUID.randomUUID().toString()));
            attObj.set("url", map.get("url"));
            String url = (String)map.get("url");
            attObj.set("tempfile", (Object)1);
            long id = StrategyLayDownHelper.genLonId(orm);
            attObj.set("id", (Object)id);
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString());
            attObj.set("status", (Object)"B");
            Date now = TimeServiceHelper.now();
            attObj.set("modifytime", (Object)now.getTime());
            attObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            if (!AttachmentServiceHelper.isTempAttachment(map)) continue;
            url = AttachmentFieldServiceHelper.saveTempToFileService((String)String.valueOf(map.get("url")), (Object)attObj.getPkValue(), (String)String.valueOf(map.get("name")));
            attObj.set("url", (Object)url);
            map.put("url", url);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attObj});
            attCol.addNew().set("fbasedataid", (Object)attObj);
        }
    }

    public static void copyAttachmentFile(DynamicObject att, DynamicObjectCollection attCol) {
        ORM orm = ORM.create();
        if (att != null) {
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            attObj.set("name", att.get("name"));
            attObj.set("size", att.get("size"));
            attObj.set("uid", (Object)("rc-upload-" + UUID.randomUUID().toString()));
            attObj.set("url", att.get("url"));
            attObj.set("tempfile", (Object)1);
            long id = StrategyLayDownHelper.genLonId(orm);
            attObj.set("id", (Object)id);
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString());
            attObj.set("status", (Object)"B");
            Date now = TimeServiceHelper.now();
            attObj.set("modifytime", (Object)now.getTime());
            attObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attObj});
            attCol.addNew().set("fbasedataid", (Object)attObj);
        }
    }

    private static long genLonId(ORM orm) {
        return orm.genLongId("bd_attachment");
    }

    public static String getPlanByJob(String entity) {
        switch (entity) {
            case "mcm_supplylayout_job": {
                return "mcm_supply_plan";
            }
            case "mcm_improve_job": {
                return "mcm_improve_plan";
            }
            case "mcm_differentiation_job": {
                return "mcm_differentiation_plan";
            }
            case "mcm_supplyrate_job": {
                return "mcm_supplyrate_plan";
            }
            case "mcm_reduce_job": {
                return "mcm_reduce_plan";
            }
        }
        return null;
    }

    public static String getJobByPlan(String entity) {
        switch (entity) {
            case "mcm_supply_plan": {
                return "mcm_supplylayout_job";
            }
            case "mcm_improve_plan": {
                return "mcm_improve_job";
            }
            case "mcm_differentiation_plan": {
                return "mcm_differentiation_job";
            }
            case "mcm_supplyrate_plan": {
                return "mcm_supplyrate_job";
            }
            case "mcm_reduce_plan": {
                return "mcm_reduce_job";
            }
        }
        return null;
    }

    public static OperateOption createOpOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        return option;
    }

    public static void saveBillInfo(String targetPlan, Set<Object> ids, String property, String type) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)StrategyLayDownHelper.class.getName(), (String)targetPlan, (String)"id", (QFilter[])new QFilter[]{new QFilter(property, "in", ids)}, null);){
            DynamicObject[] plans;
            HashSet<Long> planIds = new HashSet<Long>();
            for (Row row : dataSet) {
                planIds.add(row.getLong("id"));
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)targetPlan);
            for (DynamicObject plan : plans = BusinessDataServiceHelper.load((Object[])planIds.toArray(), (DynamicObjectType)dynamicObject.getDynamicObjectType())) {
                if ("1".equals(type)) {
                    DynamicObjectCollection entryentity = plan.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryentity) {
                        row.set("progress", (Object)"2");
                    }
                    plan.set("billstatus", (Object)"D");
                    continue;
                }
                plan.set("jobstatus", (Object)"E");
            }
            SaveServiceHelper.save((DynamicObject[])plans);
        }
    }

    public static DynamicObject getExecuteJobInfo(Long billId, String targetEntity, Object resultaudit, Object resultauditnote) {
        DynamicObject[] executeJobInfo = StrategyLayDownHelper.getExecuteJobInfo(new Object[]{billId}, targetEntity, resultaudit, resultauditnote);
        if (executeJobInfo != null && executeJobInfo.length == 1) {
            return executeJobInfo[0];
        }
        return null;
    }

    public static DynamicObject[] getExecuteJobInfo(Object[] billIds, String targetEntity, Object resultaudit, Object resultauditnote) {
        DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)targetEntity);
        if (entity != null) {
            DynamicObject[] jobInfos;
            for (DynamicObject jobInfo : jobInfos = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)entity.getDynamicObjectType())) {
                if (jobInfo == null) continue;
                DynamicObjectCollection entryentityaudit = jobInfo.getDynamicObjectCollection("entryentityinfo");
                DynamicObject row = entryentityaudit.addNew();
                row.set("dealtype", (Object)"2");
                row.set("exeresult", (Object)("0".equals(resultaudit) ? "3" : "4"));
                row.set("realview", resultauditnote);
                row.set("replyperson_id", (Object)RequestContext.get().getCurrUserId());
                row.set("replytime", (Object)TimeServiceHelper.now());
            }
            return jobInfos;
        }
        return null;
    }

    public static List<ComboItem> getYearComboItem(String defaultYear) {
        int year = 0;
        int i = 3;
        if (StringUtils.isNotBlank((CharSequence)defaultYear)) {
            year = Integer.parseInt(defaultYear);
        }
        Calendar instance = Calendar.getInstance();
        instance.setTime(TimeServiceHelper.now());
        int endYear = instance.get(1);
        if (year != 0) {
            i = endYear - year >= 1 ? endYear - year + i : i;
        } else {
            year = endYear;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(i);
        for (int j = 0; j < i; ++j) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(String.valueOf(year)));
            comboItem.setValue(String.valueOf(year));
            comboItems.add(comboItem);
            ++year;
        }
        return comboItems;
    }

    public static List<ValueMapItem> getYearValueMapItem(String defaultYear) {
        int year = 0;
        int i = 3;
        if (StringUtils.isNotBlank((CharSequence)defaultYear)) {
            year = Integer.parseInt(defaultYear);
        }
        Calendar instance = Calendar.getInstance();
        instance.setTime(TimeServiceHelper.now());
        int endYear = instance.get(1);
        if (year != 0) {
            i = endYear - year > 1 ? endYear - year + i : i;
        } else {
            year = endYear;
        }
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(i);
        for (int j = 0; j < i; ++j) {
            ValueMapItem comboItem = new ValueMapItem();
            comboItem.setName(new LocaleString(String.valueOf(year)));
            comboItem.setValue(String.valueOf(year));
            comboItems.add(comboItem);
            ++year;
        }
        return comboItems;
    }

    public static String getChangeUIByplan(String entity) {
        switch (entity) {
            case "mcm_supply_plan": {
                return "mcm_supply_plan_change";
            }
            case "mcm_improve_plan": {
                return "mcm_improve_plan_change";
            }
            case "mcm_differentiation_plan": {
                return "mcm_diff_plan_change";
            }
            case "mcm_supplyrate_plan": {
                return "mcm_supplyrateplan_change";
            }
            case "mcm_reduce_plan": {
                return "mcm_reduce_plan_change";
            }
        }
        return "";
    }

    public static String getChangeBillUIByplan(String entity) {
        switch (entity) {
            case "mcm_supply_plan": {
                return "mcm_supplyplan_change";
            }
            case "mcm_improve_plan": {
                return "mcm_improveplanchangebill";
            }
            case "mcm_differentiation_plan": {
                return "mcm_diffplan_changebill";
            }
            case "mcm_supplyrate_plan": {
                return "mcm_supplyrate_changebill";
            }
            case "mcm_reduce_plan": {
                return "mcm_reduce_planchangebill";
            }
        }
        return "";
    }

    public static OperationResult executeResultAudit(Long billId, String targetEntity, Object resultaudit, Object resultauditnote) {
        return StrategyLayDownHelper.executeResultAudit(new Object[]{billId}, targetEntity, resultaudit, resultauditnote);
    }

    public static OperationResult executeResultAudit(Object[] billIds, String targetEntity, Object resultaudit, Object resultauditnote) {
        OperationResult result = null;
        DynamicObject[] jobInfos = StrategyLayDownHelper.getExecuteJobInfo(billIds, targetEntity, resultaudit, resultauditnote);
        if (jobInfos != null) {
            OperateOption opOption = StrategyLayDownHelper.createOpOption();
            opOption.setVariableValue("ishasright", String.valueOf(Boolean.FALSE));
            if ("0".equals(resultaudit)) {
                opOption.setVariableValue("reject", "D");
                result = OperationServiceHelper.executeOperate((String)"unsubmit", (String)targetEntity, (DynamicObject[])jobInfos, (OperateOption)opOption);
            } else {
                result = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntity, (DynamicObject[])jobInfos, (OperateOption)opOption);
            }
        }
        return result;
    }

    public static boolean checkHasJob(String entityName, Set<Object> planids, String[] status) {
        String jobbillname = StrategyLayDownHelper.getJobByPlan(entityName);
        QFilter filter = new QFilter("sourcebill", "in", planids);
        filter.and(new QFilter("jobstatus", "in", (Object)status));
        boolean hasJob = QueryServiceHelper.exists((String)jobbillname, (QFilter[])filter.toArray());
        return hasJob;
    }

    public static boolean checkHasJobByEntry(String entityName, Set<Object> planentryids, String[] status) {
        String jobbillname = StrategyLayDownHelper.getJobByPlan(entityName);
        QFilter filter = new QFilter("sourceentryid", "in", planentryids);
        filter.and(new QFilter("jobstatus", "in", (Object)status));
        boolean hasJob = QueryServiceHelper.exists((String)jobbillname, (QFilter[])filter.toArray());
        return hasJob;
    }

    public static boolean checkHasChangingPlan(String entityName, Set<Object> planentryids) {
        String jobbillname = StrategyLayDownHelper.getPlanByJob(entityName);
        String changebillname = StrategyLayDownHelper.getChangeBillUIByplan(jobbillname);
        QFilter filter = new QFilter("entryentity1.planentryid1", "in", planentryids);
        filter.and(new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}));
        boolean hasChangingPlan = QueryServiceHelper.exists((String)changebillname, (QFilter[])filter.toArray());
        return hasChangingPlan;
    }

    public static Set getJob(String entityName, Set<Object> planentryids, String[] status) {
        String jobbillname = StrategyLayDownHelper.getJobByPlan(entityName);
        QFilter filter = new QFilter("sourceentryid", "in", planentryids);
        filter.and(new QFilter("jobstatus", "in", (Object)status));
        DynamicObjectCollection col = QueryServiceHelper.query((String)jobbillname, (String)"sourceentryid", (QFilter[])filter.toArray());
        HashSet<Object> entrys = new HashSet<Object>(col.size());
        for (DynamicObject row : col) {
            entrys.add(row.get("sourceentryid"));
        }
        return entrys;
    }

    public static void dealOperationResult(OperationResult result) {
        if (result != null && !result.getValidateResult().isSuccess()) {
            StringBuilder error = new StringBuilder();
            ValidateResultCollection validateResult = result.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult validateError : validateErrors) {
                List allErrorInfo = validateError.getAllErrorInfo();
                for (OperateErrorInfo errorInfo : allErrorInfo) {
                    error.append(errorInfo.getMessage());
                }
            }
            throw new KDBizException(error.toString());
        }
    }

    public static String getJobByReport(String entity) {
        switch (entity) {
            case "mcm_supplylayout_report": {
                return "mcm_supplylayout_job";
            }
            case "mcm_improve_report": {
                return "mcm_improve_job";
            }
            case "mcm_different_report": {
                return "mcm_differentiation_job";
            }
            case "mcm_supplyrate_report": {
                return "mcm_supplyrate_job";
            }
            case "mcm_reduce_report": {
                return "mcm_reduce_job";
            }
        }
        return null;
    }

    public static String getStatIndexTargetEntityName(String statType, String type) {
        switch (statType) {
            case "improve": {
                return StringUtils.equals((CharSequence)type, (CharSequence)"strategy") ? "mcm_performimpove" : (StringUtils.equals((CharSequence)type, (CharSequence)"plan") ? "mcm_improve_plan" : "mcm_improve_job");
            }
            case "diff": {
                return StringUtils.equals((CharSequence)type, (CharSequence)"strategy") ? "mcm_differentiation" : (StringUtils.equals((CharSequence)type, (CharSequence)"plan") ? "mcm_differentiation_plan" : "mcm_differentiation_job");
            }
            case "supplylay": {
                return StringUtils.equals((CharSequence)type, (CharSequence)"strategy") ? "mcm_supplylayout" : (StringUtils.equals((CharSequence)type, (CharSequence)"plan") ? "mcm_supply_plan" : "mcm_supplylayout_job");
            }
            case "supplyscale": {
                return StringUtils.equals((CharSequence)type, (CharSequence)"strategy") ? "mcm_supplyrate" : (StringUtils.equals((CharSequence)type, (CharSequence)"plan") ? "mcm_supplyrate_plan" : "mcm_supplyrate_job");
            }
            case "reduce": {
                return StringUtils.equals((CharSequence)type, (CharSequence)"strategy") ? "mcm_reduce" : (StringUtils.equals((CharSequence)type, (CharSequence)"plan") ? "mcm_reduce_plan" : "mcm_reduce_job");
            }
        }
        return null;
    }
}

