/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;

public class DifferPlanEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        BasedataEdit category = (BasedataEdit)this.getView().getControl("category");
        if (category != null) {
            category.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (material != null) {
            material.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newentry": {
                EntryGrid strategyGrid = (EntryGrid)this.getControl("strategyinfo");
                int[] selectRows = strategyGrid.getSelectRows();
                if (selectRows.length != 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u4e00\u6761\u7b56\u7565\u4fe1\u606f\u3002", (String)"DifferPlanEdit_0", (String)"scm-mcm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "material": {
                this.getModel().beginInit();
                for (ChangeData changeData : changeSet) {
                    Object newValue = changeData.getNewValue();
                    Object type = this.getModel().getValue("type", changeData.getRowIndex());
                    if (newValue == null) {
                        this.getModel().setValue("category", null, changeData.getRowIndex());
                        continue;
                    }
                    if (!"1".equals(type)) continue;
                    this.getModel().setValue("type", (Object)"2", changeData.getRowIndex());
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)name)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            EntryGrid strategyGrid = (EntryGrid)this.getControl("strategyinfo");
            int[] selectRows = strategyGrid.getSelectRows();
            DynamicObjectCollection strategyinfo = this.getModel().getDataEntity(true).getDynamicObjectCollection("strategyinfo");
            if (selectRows.length > 0) {
                DynamicObject dynamicObject = (DynamicObject)strategyinfo.get(selectRows[0]);
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.getModel().setValue("categorylevel_id", (Object)dynamicObject.getLong("categorylevel_stgy_id"), rowIndex);
                    this.getModel().setValue("categorylevel", (Object)dynamicObject.getDynamicObject("categorylevel_stgy"), rowIndex);
                    this.getModel().setValue("policytype", (Object)dynamicObject.getString("policytype_stgy"), rowIndex);
                    this.getModel().setValue("policy", (Object)dynamicObject.getString("policy_stgy"), rowIndex);
                    this.getModel().setValue("policy_tag", (Object)dynamicObject.getString("policy_stgy_tag"), rowIndex);
                    this.getModel().setValue("starttime", (Object)dynamicObject.getDate("starttime_stgy"), rowIndex);
                    this.getModel().setValue("endtime", (Object)dynamicObject.getDate("endtime_stgy"), rowIndex);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "category": 
            case "material": {
                List customQFilters = e.getCustomQFilters();
                QFilter qFilter = null;
                int row = e.getRow();
                Object categorylevel = this.getModel().getValue("categorylevel_id", row);
                QFilter qFilter1 = new QFilter("bd_categorylevel.grade", "=", categorylevel);
                qFilter1.and("bd_categorylevel.enable", "=", (Object)Boolean.TRUE);
                qFilter1.and("bd_categorylevel.status", "=", (Object)"C");
                qFilter = "category".equals(name) ? QFilter.join((String)"id", (String)"bd_categorylevel.category", (QFilter)qFilter1, (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)true) : QFilter.join((String)"id", (String)"bd_categorylevel.material", (QFilter)qFilter1, (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)true);
                customQFilters.add(qFilter);
                break;
            }
        }
    }
}

