/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.edit.stat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.mcm.formplugin.edit.stat.StrategyStatFilterEdit;

public class StrategyJobPassTopStatEditPlugin
extends StrategyStatFilterEdit {
    public void registerListener(EventObject e) {
        HistogramChart histogramchartap = (HistogramChart)this.getControl("histogramchartap");
        histogramchartap.addClickListener((ClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void doGetAndCreateStatInfo() {
        String stattype = this.getStatType();
        String jobEntity = this.getJobEntity(stattype);
        if (StringUtils.isBlank((CharSequence)jobEntity)) {
            return;
        }
        QFilter strategyJobFilter = this.getStrategyJobFilter(stattype);
        strategyJobFilter.and("jobstatus", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)jobEntity, (String)"id,planendtime,jobstatus,org,org.name orgname,entryentityinfo.exeresult exeresult", (QFilter[])new QFilter[]{strategyJobFilter}, null);
        DataSet finish = dataSet.groupBy(new String[]{"org", "orgname", "id"}).reduceGroup(new ReduceGroupFunctionWithCollector(){

            public void reduce(Iterator<Row> iterator, Collector collector) {
                boolean flag = true;
                long orgId = 0L;
                long id = 0L;
                String orgName = "";
                while (iterator.hasNext()) {
                    Row next = iterator.next();
                    String exeresult = next.getString("exeresult");
                    if ("3".equals(exeresult)) {
                        flag = false;
                    }
                    orgId = next.getLong("org");
                    id = next.getLong("id");
                    orgName = next.getString("orgname");
                }
                collector.collect(new Object[]{orgId, orgName, flag ? 1.0 : 0.0, id});
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new String[]{"org", "orgname", "pass", "id"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.DoubleType, DataType.LongType});
            }
        });
        DataSet top = finish.groupBy(new String[]{"org", "orgname"}).countDistinct(new String[]{"id"}, "total").sum("pass").finish();
        DataSet top1 = top.select(new String[]{"orgname", "org", "total", "case when total = 0 then 0 else ROUND(pass/total,4) end percent "}).orderBy(new String[]{"percent desc"}).top(10);
        ArrayList<String> categorys = new ArrayList<String>(10);
        ArrayList<Double> numbers = new ArrayList<Double>(10);
        HashMap<String, String> nameMapOrg = new HashMap<String, String>(10);
        for (Row row : top1) {
            String orgname = row.getString("orgname");
            nameMapOrg.put(orgname, row.getString("org"));
            categorys.add(orgname);
            double pass = row.getDouble("percent");
            numbers.add(BigDecimal.valueOf(pass * 100.0).setScale(2, 4).doubleValue());
        }
        this.getView().getPageCache().put("orgcategory", SerializationUtils.toJsonString(nameMapOrg));
        HistogramChart histogramchartap = (HistogramChart)this.getControl("histogramchartap");
        Axis axis = histogramchartap.createXAxis(ResManager.loadKDString((String)"\u5b8c\u6210\u4eba", (String)"StrategyJobPassTopStatEditPlugin_0", (String)"scm-mcm", (Object[])new Object[0]), categorys.toArray(new String[0]));
        ArrayList datas = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", ResManager.loadKDString((String)"\u4e00\u6b21\u901a\u8fc7\u7387", (String)"StrategyJobPassTopStatEditPlugin_1", (String)"scm-mcm", (Object[])new Object[0]));
        data.put("type", "bar");
        data.put("stack", "total");
        data.put("barWidth", "20%");
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("interval", 0);
        axisLabel.put("rotate", -20);
        axisLabel.put("fontSize", 11);
        axisLabel.put("color", "#666666");
        axis.setPropValue("axisLabel", axisLabel);
        data.put("color", new String[]{"#FFC53D"});
        HashMap<String, String> emphasis = new HashMap<String, String>();
        emphasis.put("focus", "series");
        data.put("emphasis", emphasis);
        data.put("data", numbers);
        datas.add(data);
        Axis yAxis = histogramchartap.createYAxis("%", AxisType.value);
        yAxis.setMin((Number)0);
        yAxis.setMax((Number)100);
        HashMap<String, String> tooltips = new HashMap<String, String>();
        tooltips.put("show", "true");
        tooltips.put("trigger", "axis");
        tooltips.put("formatter", "{b}:{c} %");
        histogramchartap.addProperty("tooltip", tooltips);
        histogramchartap.addProperty("series", datas);
        HashMap<String, String> gridMap = new HashMap<String, String>();
        gridMap.put("top", "15%");
        histogramchartap.addProperty("grid", gridMap);
    }

    public void click(EventObject e) {
        String name = ((ChartClickEvent)e).getName();
        String s = this.getView().getPageCache().get("orgcategory");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            String jobEntity;
            Map categoryMap = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
            if (categoryMap == null) {
                return;
            }
            s = (String)categoryMap.get(name);
            if (StringUtils.isBlank((CharSequence)s)) {
                return;
            }
            Long aLong = Long.valueOf(s);
            String statType = this.getStatType();
            QFilter strategyJobFilter = this.getStrategyJobFilter(statType);
            if (strategyJobFilter != null) {
                strategyJobFilter.and("org.id", "=", (Object)aLong);
            }
            if (StringUtils.isBlank((CharSequence)(jobEntity = this.getJobEntity(statType)))) {
                return;
            }
            this.showTargetForm(strategyJobFilter, jobEntity);
        }
        super.click(e);
    }
}

