/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.edit.stat;

import java.util.EventObject;
import java.util.Formatter;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.mcm.formplugin.edit.stat.StrategyStatFilterEdit;

public class StrategyJobPieStatEditPlugin
extends StrategyStatFilterEdit
implements ClickListener {
    private static final Log logger = LogFactory.getLog(StrategyJobPieStatEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        PieChart piechartap = (PieChart)this.getControl("piechartap");
        piechartap.addClickListener((ClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGetAndCreateStatInfo() {
        String statType = this.getStatType();
        String jobEntity = this.getJobEntity(statType);
        if (StringUtils.isBlank((CharSequence)jobEntity)) {
            return;
        }
        QFilter strategyJobFilter = this.getStrategyJobFilter(statType);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)jobEntity, (String)"(case when jobstatus = 'C' then 1 else 0 end ) finishnum,(case when jobstatus != 'E' then 1 else 0 end ) total,org,year", (QFilter[])new QFilter[]{strategyJobFilter}, null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"year"});
        GroupbyDataSet sum = groupbyDataSet.sum("finishnum").sum("total");
        DataSet finish = sum.finish();
        int total = 0;
        int finishNumb = 0;
        for (Row row : finish) {
            finishNumb = row.getInteger("finishnum");
            total = row.getInteger("total");
        }
        PieChart piechartap = (PieChart)this.getControl("piechartap");
        PieSeries series = piechartap.createPieSeries("");
        String haveDone = String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u4efb\u52a1\u6570     %1$s", (String)"StrategyJobPieStatEditPlugin_0", (String)"scm-mcm", (Object[])new Object[0]), finishNumb);
        String unDone = String.format(ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u4efb\u52a1\u6570     %1$s", (String)"StrategyJobPieStatEditPlugin_1", (String)"scm-mcm", (Object[])new Object[0]), total - finishNumb);
        this.getView().getPageCache().put(haveDone, "havedone");
        this.getView().getPageCache().put(unDone, "undo");
        series.addData(haveDone, (Number)finishNumb, "#1890FF");
        series.addData(unDone, (Number)(total - finishNumb), "#dfe2e4");
        HashMap<String, String> label = new HashMap<String, String>();
        double perc = (finishNumb == 0 ? (double)finishNumb : (double)finishNumb / (double)total) * 100.0;
        try (Formatter formatter = new Formatter();){
            label.put("formatter", formatter.format("%.2f", perc).toString() + "%");
        }
        label.put("position", "center");
        label.put("show", "true");
        label.put("fontSize", "20");
        label.put("color", "#212121");
        series.setPropValue("label", label);
        series.setRadius("65%", "80%");
        piechartap.setLegendVertical(true);
        series.setPropValue("center", (Object)new String[]{"30%", "50%"});
        HashMap<String, Object> legendMap = new HashMap<String, Object>(5);
        legendMap.put("padding", new Number[]{0, 50, 0, 0});
        legendMap.put("icon", "circle");
        legendMap.put("left", "65%");
        legendMap.put("top", "middle");
        legendMap.put("orient", "vertical");
        piechartap.addProperty("legend", legendMap);
    }

    public void click(EventObject e) {
        super.click(e);
        if (e instanceof ChartClickEvent) {
            String name = ((ChartClickEvent)e).getName();
            String value = this.getView().getPageCache().get(name);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String statType = this.getStatType();
                String jobEntity = this.getJobEntity(statType);
                if (StringUtils.isBlank((CharSequence)jobEntity)) {
                    return;
                }
                QFilter strategyJobFilter = this.getStrategyJobFilter(statType);
                if (StringUtils.equals((CharSequence)"havedone", (CharSequence)value)) {
                    strategyJobFilter.and("jobstatus", "=", (Object)"C");
                } else {
                    strategyJobFilter.and("jobstatus", "!=", (Object)"C");
                }
                this.showTargetForm(strategyJobFilter, jobEntity);
            }
        }
    }
}

