/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.edit.stat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.scm.mcm.common.StrategyLayDownHelper;

abstract class StrategyStatFilterEdit
extends GridCardPlugin {
    private static final List<String> QUARTER = new ArrayList<String>(4);
    private static final Log logger = LogFactory.getLog(StrategyStatFilterEdit.class);
    private static final String STAT_TYPE = "stattype";

    StrategyStatFilterEdit() {
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().showLoading(ResManager.getLocaleString((String)"\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"StrategyStatFilterEdit_0", (String)"scm-mcm"));
        this.doGetAndCreateStatInfo();
        this.getView().hideLoading();
    }

    protected abstract void doGetAndCreateStatInfo();

    protected final Object getParamValue(IFormView view, String name, boolean isList, int deep) {
        if (view == null) {
            return null;
        }
        String paramValue = view.getPageCache().get(name);
        if (deep < 2) {
            if (StringUtils.isBlank((CharSequence)paramValue)) {
                return this.getParamValue(view.getParentView(), name, isList, deep + 1);
            }
            if (isList) {
                return SerializationUtils.fromJsonString((String)paramValue, List.class);
            }
            return paramValue;
        }
        return null;
    }

    public final QFilter getStrategyFilter() {
        QFilter filter = this.filter("entryentityorg.exeorg", "", false);
        Object org = this.getParamValue(this.getView(), "org", true, 0);
        if (filter != null) {
            if (org instanceof List && ((List)org).size() > 0) {
                filter.and("org", "in", org);
            }
            filter.and("isuse", "=", (Object)Boolean.TRUE);
        }
        return filter;
    }

    public final QFilter getStrategyPlanFilter(String statType) {
        QFilter qFilter = this.filter("sourcebill", statType, true);
        Object exeorg = this.getParamValue(this.getView(), "exeorg", true, 0);
        if (qFilter != null) {
            if (exeorg instanceof List && ((List)exeorg).size() > 0) {
                qFilter.and("org", "in", exeorg);
            }
            qFilter.and("billstatus", "in", (Object)new String[]{"A", "B", "C"});
        }
        return qFilter;
    }

    public final QFilter getStrategyJobFilter(String statType) {
        QFilter filter = this.filter("strategyid", statType, true);
        Object exeorg = this.getParamValue(this.getView(), "exeorg", true, 0);
        if (filter != null && exeorg instanceof List && ((List)exeorg).size() > 0) {
            filter.and("org", "in", exeorg);
        }
        if (filter != null) {
            filter.and("jobstatus", "in", (Object)new String[]{"A", "B", "C", "D"});
        }
        return filter;
    }

    private QFilter filter(String property, String statType, boolean widthStrategy) {
        Object year = this.getParamValue(this.getView(), "year", false, 0);
        QFilter qFilter = new QFilter("year", "=", year);
        if (widthStrategy) {
            String strategyEntity = this.getStrategyEntity(statType);
            Object org = this.getParamValue(this.getView(), "org", true, 0);
            if (org instanceof List && ((List)org).size() > 0 && StringUtils.isNotBlank((CharSequence)strategyEntity)) {
                QFilter qFilter1 = QFilter.join((String)property, (String)(strategyEntity + ".id"), (QFilter)new QFilter(strategyEntity + ".org", "in", org));
                qFilter.and(qFilter1);
            }
        } else {
            Object exeorg = this.getParamValue(this.getView(), "exeorg", true, 0);
            if (qFilter != null && exeorg instanceof List && ((List)exeorg).size() > 0) {
                qFilter.and(property, "in", exeorg);
            }
        }
        return qFilter;
    }

    private final String getStrategyEntity(String statType) {
        return StrategyLayDownHelper.getStatIndexTargetEntityName(statType, "strategy");
    }

    protected final String getPlanEntity(String statType) {
        return StrategyLayDownHelper.getStatIndexTargetEntityName(statType, "plan");
    }

    protected final String getJobEntity(String statType) {
        return StrategyLayDownHelper.getStatIndexTargetEntityName(statType, "job");
    }

    public String getStatType() {
        String statType1;
        String statType = "supplylay";
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(statType1 = this.getView().getParentView().getPageCache().get(STAT_TYPE)))) {
            statType = statType1;
        }
        return statType;
    }

    protected final List<String> getQuarter() {
        return Collections.unmodifiableList(QUARTER);
    }

    protected final QFilter getQuarterFilter(String quarter) {
        String statType = this.getStatType();
        String jobEntity = this.getJobEntity(statType);
        int i = QUARTER.indexOf(quarter);
        if (StringUtils.isBlank((CharSequence)jobEntity)) {
            return null;
        }
        Object year = this.getParamValue(this.getView(), "year", false, 0);
        Integer yearValue = null;
        QFilter strategyJobFilter = this.getStrategyJobFilter(statType);
        try {
            if (i >= 0) {
                yearValue = Integer.valueOf(String.valueOf(year));
                Calendar calendar = Calendar.getInstance();
                calendar.set(yearValue, i * 3, 1, 0, 0, 0);
                Calendar clone = (Calendar)calendar.clone();
                clone.set(yearValue, (i + 1) * 3, 1, 0, 0, 0);
                if (strategyJobFilter != null) {
                    strategyJobFilter.and("planendtime", ">=", (Object)calendar.getTime());
                    strategyJobFilter.and("planendtime", "<", (Object)clone.getTime());
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error("StrategyStatFilterEdit year number format exception:" + e.getMessage());
        }
        return strategyJobFilter;
    }

    protected final void showTargetForm(QFilter qFilter, String entity) {
        ListShowParameter showParameter = StrategyLayDownHelper.createShowParameter(entity, qFilter);
        Object org = this.getParamValue(this.getView(), "org", true, 0);
        showParameter.getCustomParams().put("org.id", SerializationUtils.toJsonString((Object)org));
        showParameter.addCustPlugin("kd.scm.mcm.formplugin.list.StrategyStatIndexList");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    static {
        QUARTER.add("Q1");
        QUARTER.add("Q2");
        QUARTER.add("Q3");
        QUARTER.add("Q4");
    }
}

