/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.edit.stat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mcm.business.IStrategyStatService;
import kd.scm.mcm.business.impl.StrategyStatServiceImpl;
import kd.scm.mcm.common.StrategyLayDownHelper;
import kd.scm.mcm.formplugin.edit.stat.StrategyStatFilterEdit;

public class StrategyStatIndexEditPlugin
extends StrategyStatFilterEdit
implements BeforeF7SelectListener {
    private static final String SELECTED_BACKGROUND_IMAGE = "/images/pc/cardbackground/gyl_ghbljk_252_183.png";
    private static final String UNSELECT_BACKGROUND_IMAGE = "/images/pc/cardbackground/gyl_cyhjk_252_183.png";
    private static final Map<String, String> CARD_STAT_TYPE_MAP = new HashMap<String, String>(5);
    private static final String[] STAT_INDEX_LABEL1;
    private static final String[] STAT_INDEX_LABEL2;
    private static final String[] STAT_INDEX_LABEL4;
    private static final String[] STAT_INDEX_LABEL3;
    private static final String[] STAT_DETAIL_PAGE;
    private static final String VIEW_ITEM_ID = "1JBQ8FS1/MM1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit org = (MulBasedataEdit)this.getControl("org");
        MulBasedataEdit exeorg = (MulBasedataEdit)this.getControl("exeorg");
        org.addBeforeF7SelectListener(this::beforeF7Select);
        exeorg.addBeforeF7SelectListener(this::beforeF7Select);
        Button realtimequery = (Button)this.getControl("realtimequery");
        realtimequery.addClickListener((ClickListener)this);
        CARD_STAT_TYPE_MAP.entrySet().forEach(info -> {
            info.getKey();
            String value = (String)info.getValue();
            this.addClickListeners(new String[]{value + "_num"});
            this.addClickListeners(new String[]{(String)info.getKey()});
        });
    }

    public void beforeBindData(EventObject e) {
        List comboItems;
        super.beforeBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl("year");
        DynamicProperty year = this.getView().getModel().getDataEntity().getDynamicObjectType().getProperty("year");
        String defaultValue = "2023";
        if (year instanceof ComboProp && (comboItems = ((ComboProp)year).getComboItems()).size() > 0) {
            ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(0);
            defaultValue = valueMapItem.getValue();
        }
        comboItems = StrategyLayDownHelper.getYearComboItem(defaultValue);
        comboEdit.setComboItems(comboItems);
        comboEdit.setMustInput(true);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String statType = this.getStatType();
        this.switchStyle(statType, true);
        Calendar instance = Calendar.getInstance();
        instance.setTime(TimeServiceHelper.now());
        int endYear = instance.get(1);
        this.getModel().setValue("year", (Object)String.valueOf(endYear));
        HasPermOrgResult permissionOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"32WSHW0OE+O7", (String)"mcm_strategy_statindex", (String)VIEW_ITEM_ID, (boolean)true);
        List hasPermOrgs = permissionOrgs.getHasPermOrgs();
        if (hasPermOrgs.size() > 0 || permissionOrgs.hasAllOrgPerm()) {
            if (hasPermOrgs.contains(RequestContext.get().getOrgId()) || permissionOrgs.hasAllOrgPerm()) {
                this.getModel().setValue("org", (Object)new Long[]{RequestContext.get().getOrgId()});
            } else {
                this.getModel().setValue("org", (Object)new Long[]{(Long)hasPermOrgs.get(0)});
            }
            this.putParamToCache();
        }
        super.afterCreateNewData(e);
    }

    @Override
    protected void doGetAndCreateStatInfo() {
        IStrategyStatService strategyStatService = this.getStrategyStatService();
        HashMap statMap = new HashMap();
        CARD_STAT_TYPE_MAP.entrySet().forEach(info -> {
            String value = (String)info.getValue();
            QFilter strategyFilter = this.getStrategyFilter();
            QFilter strategyPlanFilter = this.getStrategyPlanFilter(value);
            QFilter strategyJobFilter = this.getStrategyJobFilter(value);
            Map<String, Object> strategyStatInfo = strategyStatService.getStrategyStatInfo(value, strategyFilter, strategyPlanFilter, strategyJobFilter);
            statMap.putAll(strategyStatInfo);
        });
        CARD_STAT_TYPE_MAP.entrySet().forEach(info -> {
            String value = (String)info.getValue();
            this.setStatLabelValue(value, STAT_INDEX_LABEL2, statMap);
            this.setStatLabelValue(value, STAT_INDEX_LABEL3, statMap);
        });
        this.getView().addClientCallBack("clientCallBack");
    }

    private IStrategyStatService getStrategyStatService() {
        return new StrategyStatServiceImpl();
    }

    private void setStatLabelValue(String value, String[] labels, Map<String, Object> statMap) {
        if (statMap == null) {
            return;
        }
        for (String label : labels) {
            Label label1 = (Label)this.getControl(value + label);
            Object orDefault = statMap.getOrDefault(value + label, "0");
            if (label1 == null) continue;
            label1.setText(String.valueOf(orDefault));
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        String panelAp = CARD_STAT_TYPE_MAP.get(key);
        if (StringUtils.isNotBlank((CharSequence)panelAp) || StringUtils.equals((CharSequence)key, (CharSequence)"realtimequery")) {
            MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("org");
            MulBasedataDynamicObjectCollection exeorgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("exeorg");
            if (!(orgs != null && orgs.size() != 0 || exeorgs != null && exeorgs.size() != 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7b56\u7565\u521b\u5efa\u7ec4\u7ec7\u201d\u6216\u201c\u7b56\u7565\u6267\u884c\u7ec4\u7ec7\u201d\u3002", (String)"StrategyStatIndexEditPlugin_0", (String)"scm-mcm", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)panelAp)) {
            this.getPageCache().put("stattype", panelAp);
            this.switchStyle(panelAp, true);
            this.getView().addClientCallBack("clientCallBack");
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"realtimequery")) {
            this.putParamToCache();
            this.doGetAndCreateStatInfo();
        }
        if (key.indexOf("_num") > 0) {
            key = key.replace("_num", "");
            IStrategyStatService strategyStatService = this.getStrategyStatService();
            String strategy = strategyStatService.getTargetEntityName(key, "strategy");
            if (StringUtils.isNotBlank((CharSequence)strategy)) {
                QFilter strategyFilter = this.getStrategyFilter();
                this.showTargetForm(strategyFilter, strategy);
            }
        }
    }

    private void putParamToCache() {
        Object year = this.getModel().getValue("year");
        this.getView().getPageCache().put("year", String.valueOf(year));
        List<Object> orgs = this.getMulBaseDataIds("org");
        List<Object> exeorgs = this.getMulBaseDataIds("exeorg");
        this.getPageCache().put("exeorg", SerializationUtils.toJsonString(exeorgs));
        this.getPageCache().put("org", SerializationUtils.toJsonString(orgs));
    }

    private List<Object> getMulBaseDataIds(String org) {
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue(org);
        ArrayList<Object> baseDatas = new ArrayList<Object>(orgs.size());
        for (DynamicObject baseData : orgs) {
            baseDatas.add(baseData.getLong("fbasedataid_id"));
        }
        return baseDatas;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (e.getName().equals("clientCallBack")) {
            this.showAllStatDetailPage();
        }
    }

    private void showAllStatDetailPage() {
        for (String subPage : STAT_DETAIL_PAGE) {
            String statDetailEntity = this.getStatDetailEntity(subPage);
            if (!StringUtils.isNotBlank((CharSequence)statDetailEntity)) continue;
            FormShowParameter param = new FormShowParameter();
            param.setFormId(statDetailEntity);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey(subPage);
            param.setStatus(OperationStatus.EDIT);
            this.getView().showForm(param);
        }
    }

    private String getStatDetailEntity(String flexPanelAp) {
        switch (flexPanelAp) {
            case "statpage1": {
                return "mcm_strategy_jobpie";
            }
            case "statpage2": {
                return "mcm_strategy_jobexecute";
            }
            case "statpage3": {
                return "mcm_strategy_jobtop5";
            }
            case "statpage4": {
                return "mcm_strategy_jobpasstop";
            }
            case "statpage5": {
                return "mcm_strategy_jobwarm";
            }
            case "statpage6": {
                return "mcm_strategy_jobtop10";
            }
        }
        return "";
    }

    private void switchStyle(String statType, boolean selected) {
        for (Map.Entry<String, String> next : CARD_STAT_TYPE_MAP.entrySet()) {
            String value = next.getValue();
            Container panelAp = (Container)this.getControl(value + "_panelap");
            if (StringUtils.equals((CharSequence)value, (CharSequence)statType)) {
                panelAp.setBackgroundImg(SELECTED_BACKGROUND_IMAGE);
                this.getView().setVisible(Boolean.valueOf(selected), new String[]{value + "_selected"});
                this.setCardFontStyle(value, !selected);
                continue;
            }
            panelAp.setBackgroundImg(UNSELECT_BACKGROUND_IMAGE);
            this.getView().setVisible(Boolean.valueOf(!selected), new String[]{value + "_selected"});
            this.setCardFontStyle(value, selected);
        }
        this.getPageCache().put("stattype", statType);
    }

    private void setCardFontStyle(String statType, boolean selected) {
        this.setCardFontStyle(STAT_INDEX_LABEL1, statType, selected, "#979797", "#FFFFFF");
        this.setCardFontStyle(STAT_INDEX_LABEL2, statType, selected, "#666666", "#FFFFFF");
        this.setCardFontStyle(STAT_INDEX_LABEL4, statType, selected, "#666666", "#FFFFFF");
        this.setCardFontStyle(STAT_INDEX_LABEL3, statType, selected, "#FF7400", "#FFFFFF");
    }

    private void setCardFontStyle(String[] labels, String statType, boolean selected, String selectedColor, String unselectColor) {
        for (String label : labels) {
            HashMap<String, String> titleParam = new HashMap<String, String>(1);
            titleParam.put("fc", selected ? selectedColor : unselectColor);
            if (label.equals("_num")) {
                titleParam.put("fw", selected ? "300" : "600");
            }
            this.getView().updateControlMetadata(statType + label, titleParam);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": 
            case "exeorg": {
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                formShowParameter.setMultiSelect(true);
                HasPermOrgResult permissionOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"32WSHW0OE+O7", (String)"mcm_strategy_statindex", (String)VIEW_ITEM_ID, (boolean)true);
                List hasPermOrgs = permissionOrgs.getHasPermOrgs();
                QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgs);
                List qFilters = formShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(orgFilter);
                break;
            }
        }
    }

    static {
        CARD_STAT_TYPE_MAP.put("supplylay_panelap", "supplylay");
        CARD_STAT_TYPE_MAP.put("improve_panelap", "improve");
        CARD_STAT_TYPE_MAP.put("diff_panelap", "diff");
        CARD_STAT_TYPE_MAP.put("supplyscale_panelap", "supplyscale");
        CARD_STAT_TYPE_MAP.put("reduce_panelap", "reduce");
        STAT_INDEX_LABEL1 = new String[]{"_label", "_plantitle", "_orgtitle", "_jobtitle", "_supplytitle"};
        STAT_INDEX_LABEL2 = new String[]{"_planvalue", "_jobvalue", "_orgvalue", "_supplyvalue"};
        STAT_INDEX_LABEL4 = new String[]{"_title", "_titlevalue"};
        STAT_INDEX_LABEL3 = new String[]{"_num"};
        STAT_DETAIL_PAGE = new String[]{"statpage1", "statpage2", "statpage3", "statpage4", "statpage5", "statpage6"};
    }
}

