/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.entity.ValueMapItem;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.util.CollectionUtils;
import kd.scm.mcm.common.StrategyLayDownHelper;

public class AbstractStrategyList
extends AbstractListPlugin {
    public void initialize() {
        this.getView().getPageCache().put("year", "2023");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        String firstItem = this.getView().getPageCache().get("year");
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            this.setYearItemInfo(commonFilterColumn, firstItem);
        }
        List schemeFilterColumns = args.getSchemeFilterColumns();
        for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
            this.setYearItemInfo(schemeFilterColumn, firstItem);
        }
        super.filterContainerInit(args);
    }

    private void setYearItemInfo(FilterColumn filterColumn, String firstItem) {
        String fieldName;
        switch (fieldName = filterColumn.getFieldName()) {
            case "year": {
                List comboItems = null;
                ArrayList<ComboItem> yearComboItem = new ArrayList<ComboItem>();
                if (filterColumn instanceof SchemeFilterColumn) {
                    SchemeFilterColumn yearColumn = (SchemeFilterColumn)filterColumn;
                    comboItems = yearColumn.getComboItems();
                    yearColumn.setComboItems(yearComboItem);
                } else if (filterColumn instanceof CommonFilterColumn) {
                    CommonFilterColumn yearColumn = (CommonFilterColumn)filterColumn;
                    comboItems = yearColumn.getComboItems();
                    yearColumn.setComboItems(yearComboItem);
                }
                if (comboItems != null && comboItems.size() > 0) {
                    firstItem = ((ComboItem)comboItems.get(0)).getValue();
                }
                yearComboItem.addAll(StrategyLayDownHelper.getYearComboItem(firstItem));
            }
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        if ("year".equals(args.getListFieldKey())) {
            ValueMapItem valueMapItem;
            String defaultYear = this.getView().getPageCache().get("year");
            List comboItems = args.getComboItems();
            if (CollectionUtils.isNotEmpty((Collection)comboItems) && (valueMapItem = (ValueMapItem)comboItems.get(0)) != null) {
                defaultYear = valueMapItem.getValue();
            }
            args.getComboItems().clear();
            args.getComboItems().addAll(StrategyLayDownHelper.getYearValueMapItem(defaultYear));
        }
        super.listColumnCompareTypesSet(args);
    }
}

