/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.formplugin.list;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.mcm.common.StrategyLayDownHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StrategyExportListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(StrategyExportListPlugin.class);
    private static final String DROPDOWN_CUSTOM_ITEM = "dropdown_custom_item";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        if (file != null) {
            XSSFWorkbook wb = null;
            FileOutputStream out = null;
            try {
                try (FileInputStream fis = new FileInputStream(file);){
                    wb = new XSSFWorkbook((InputStream)fis);
                    Sheet sheet = wb.getSheetAt(0);
                    Row row = sheet.getRow(2);
                    Iterator cellIterator = row.cellIterator();
                    int i = -1;
                    while (cellIterator.hasNext()) {
                        Cell next = (Cell)cellIterator.next();
                        if (!next.getStringCellValue().equals("year")) continue;
                        i = next.getColumnIndex();
                        break;
                    }
                    if (i != -1) {
                        DataValidationHelper dataValidationHelper = sheet.getDataValidationHelper();
                        List dataValidations = sheet.getDataValidations();
                        Sheet sheet1 = wb.createSheet(DROPDOWN_CUSTOM_ITEM);
                        int index = wb.getSheetIndex(DROPDOWN_CUSTOM_ITEM);
                        Calendar instance = Calendar.getInstance();
                        instance.setTime(TimeServiceHelper.now());
                        int endYear = instance.get(1);
                        List<ComboItem> yearComboItem = StrategyLayDownHelper.getYearComboItem(String.valueOf(endYear));
                        for (int itemIndex = 0; itemIndex < yearComboItem.size(); ++itemIndex) {
                            Row row1 = sheet1.createRow(itemIndex);
                            Cell cell = row1.createCell(0);
                            cell.setCellValue(yearComboItem.get(itemIndex).getValue());
                        }
                        String strFormula = String.format("dropdown_custom_item!$%s$%d:$%s$%d", "A", 1, "A", yearComboItem.size());
                        CellRangeAddressList regions = new CellRangeAddressList(4, 10000, i, i);
                        DataValidationConstraint formulaListConstraint = dataValidationHelper.createFormulaListConstraint(strFormula);
                        DataValidation validation = dataValidationHelper.createValidation(formulaListConstraint, regions);
                        if (validation instanceof XSSFDataValidation) {
                            validation.setSuppressDropDownArrow(true);
                            validation.setShowErrorBox(true);
                        } else {
                            validation.setSuppressDropDownArrow(false);
                        }
                        sheet.addValidationData(validation);
                        wb.setSheetHidden(index, true);
                    }
                    out = new FileOutputStream(file);
                    wb.write((OutputStream)out);
                }
                this.safeCloseIO((Closeable)wb);
                this.safeCloseIO(out);
            }
            catch (Throwable ex) {
                try {
                    logger.error("strategyExport error :" + ex.getMessage());
                    this.safeCloseIO((Closeable)wb);
                    this.safeCloseIO(out);
                }
                catch (Throwable throwable) {
                    this.safeCloseIO((Closeable)wb);
                    this.safeCloseIO(out);
                    throw throwable;
                }
            }
        }
    }

    private void safeCloseIO(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                logger.error("close strategyExport io error:" + e.getMessage());
            }
        }
    }
}

