/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mcm.common.StrategyLayDownHelper;
import kd.scm.mcm.common.StrategyMapConstant;

public class StrategyPlanChangeAudit
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(StrategyPlanChangeAudit.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("planid");
        e.getFieldKeys().add("entryentity1.planentryid1");
        e.getFieldKeys().add("entryentity1.person1");
        e.getFieldKeys().add("entryentity1.starttime1");
        e.getFieldKeys().add("entryentity1.endtime1");
        e.getFieldKeys().add("entryentity1.note1");
        e.getFieldKeys().add("entryentity1.changetype");
        e.getFieldKeys().add("entryentity1.pushstatus");
        e.getFieldKeys().add("entryentity1.dpt1");
        e.getFieldKeys().add("entryentity.dpt");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Object> planids = new HashSet<Object>(dataEntities.length);
        HashSet<Object> planentryids = new HashSet<Object>(64);
        HashMap<Object, DynamicObject> changeDataMap = new HashMap<Object, DynamicObject>(64);
        HashMap<Object, DynamicObject> changebillDataMap = new HashMap<Object, DynamicObject>(64);
        HashMap<Object, Map<Object, DynamicObject>> addnewDataMap = new HashMap<Object, Map<Object, DynamicObject>>(64);
        DynamicObjectCollection entrys = null;
        HashMap<Object, DynamicObject> addnewentryDataMap = null;
        HashSet<Object> deleteids = new HashSet<Object>(64);
        HashSet<Object> addnewids = new HashSet<Object>(64);
        HashSet<Object> editids = new HashSet<Object>(64);
        for (DynamicObject bill : dataEntities) {
            changebillDataMap.put(bill.get("planid"), bill);
            planids.add(bill.get("planid"));
            entrys = bill.getDynamicObjectCollection("entryentity1");
            addnewentryDataMap = new HashMap<Object, DynamicObject>(64);
            for (DynamicObject entry : entrys) {
                String changetype = entry.getString("changetype");
                if ("2".equals(changetype)) {
                    addnewids.add(entry.getPkValue());
                    addnewentryDataMap.put(entry.getPkValue(), entry);
                    continue;
                }
                if ("3".equals(changetype)) {
                    planentryids.add(entry.get("planentryid1"));
                    deleteids.add(entry.get("planentryid1"));
                    continue;
                }
                planentryids.add(entry.get("planentryid1"));
                changeDataMap.put(entry.get("planentryid1"), entry);
                editids.add(entry.get("planentryid1"));
            }
            addnewDataMap.put(bill.get("planid"), addnewentryDataMap);
        }
        String changeEntityname = this.billEntityType.getName();
        String entityname = StrategyMapConstant.getPlanBillByChange(changeEntityname);
        if (StringUtils.isEmpty((String)entityname) || StringUtils.isEmpty((String)changeEntityname)) {
            return;
        }
        QFilter idFiler = new QFilter("id", "in", planids);
        if (planentryids.size() > 0) {
            idFiler.and(new QFilter("entryentity.id", "in", planentryids));
        }
        DynamicObject[] plandatacol = BusinessDataServiceHelper.load((String)entityname, (String)("id," + this.getSelector()), (QFilter[])idFiler.toArray());
        Set<String> inprocessids = this.closedJob(planentryids, entityname);
        this.doEditData(editids, plandatacol, changeDataMap, changebillDataMap);
        this.doDeleteData(deleteids, plandatacol);
        this.doAddnewData(addnewids, plandatacol, addnewDataMap);
        SaveServiceHelper.save((DynamicObject[])plandatacol);
        this.getOption().setVariableValue("entityname", entityname);
        this.getOption().setVariableValue("planids", SerializationUtils.toJsonString(planids));
        if (inprocessids != null && inprocessids.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                for (String businessKey : inprocessids) {
                    WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
                }
            }
            catch (Exception e1) {
                log.error("@@@\u7ec8\u6b62\u4efb\u52a1\u5355\u5de5\u4f5c\u6d41\u5931\u8d25-->" + ExceptionUtil.getStackTrace((Throwable)e1));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Map variables = this.getOption().getVariables();
        String entityname = (String)variables.get("entityname");
        String planids = (String)variables.get("planids");
        if (StringUtils.isNotEmpty((String)planids)) {
            Set ids = (Set)SerializationUtils.fromJsonString((String)planids, Set.class);
            this.push(entityname, ids);
        }
    }

    private Set<String> closedJob(Set<Object> planentryids, String entityname) {
        String jobEntityname = StrategyLayDownHelper.getJobByPlan(entityname);
        DynamicObject[] jobdatacol = BusinessDataServiceHelper.load((String)jobEntityname, (String)"id,jobstatus,billstatus,sourceentryid", (QFilter[])new QFilter("sourceentryid", "in", planentryids).toArray());
        HashSet<String> inprocessids = new HashSet<String>();
        for (DynamicObject jobdata : jobdatacol) {
            jobdata.set("jobstatus", (Object)"E");
            boolean isinprocess = WorkflowServiceHelper.inProcess((String)jobdata.getPkValue().toString());
            if (!isinprocess) continue;
            inprocessids.add(jobdata.getPkValue().toString());
        }
        SaveServiceHelper.save((DynamicObject[])jobdatacol);
        return inprocessids;
    }

    protected String getSelector() {
        return "id,entryentity,entryentity.person,entryentity.dpt,entryentity.starttime,entryentity.endtime,entryentity.note,entryentity.pushstatus";
    }

    protected void doDeleteData(Set deleteids, DynamicObject[] plandatacol) {
    }

    protected void doAddnewData(Set addnewids, DynamicObject[] plandatacol, Map<Object, Map<Object, DynamicObject>> addnewDataMap) {
    }

    protected void doEditData(Set editids, DynamicObject[] plandatacol, Map<Object, DynamicObject> changeDataMap, Map<Object, DynamicObject> changebillDataMap) {
        for (DynamicObject plandata : plandatacol) {
            DynamicObject changebilldata = changebillDataMap.get(plandata.getPkValue());
            this.setPropValue(changebilldata, this.getChangeFileds(), plandata, "");
            DynamicObjectCollection entrys = plandata.getDynamicObjectCollection("entryentity");
            for (DynamicObject planentry : entrys) {
                Object planentryid = planentry.getPkValue();
                if (!editids.contains(planentryid)) continue;
                DynamicObject changedata = changeDataMap.get(planentryid);
                this.setPropValue(changedata, this.getChangeEntryFileds(), planentry, "1");
                planentry.set("pushstatus", (Object)"0");
            }
        }
    }

    public void push(String entityname, Set<Object> planids) {
        QFilter idFiler = new QFilter("id", "in", planids);
        idFiler.and(new QFilter("entryentity.pushstatus", "!=", (Object)"1"));
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)entityname, (String)"id,entryentity.id", (QFilter[])idFiler.toArray());
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(planids.size());
        for (DynamicObject entry : entrys) {
            ListSelectedRow row = new ListSelectedRow(entry.get("id"));
            row.setEntryEntityKey("entryentity");
            row.setEntryPrimaryKeyValue(entry.get("entryentity.id"));
            selectedRowList.add(row);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(entityname);
        pushArgs.setTargetEntityNumber(StrategyLayDownHelper.getJobByPlan(entityname));
        pushArgs.setBuildConvReport(false);
        pushArgs.setShowReport(true);
        pushArgs.setAutoSave(true);
        pushArgs.setSelectedRows(selectedRowList);
        try {
            ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u751f\u6210\u53d8\u66f4\u5355\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"SupplyPlanChangeEdit_1", (String)"scm-mcm", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private void setPropValue(DynamicObject changedata, String[] changefileds, DynamicObject entry, String endkey) {
        if (changefileds == null || changefileds.length == 0 || changedata == null) {
            return;
        }
        for (String filed : changefileds) {
            Object value = changedata.get(filed + endkey);
            entry.set(filed, value);
        }
    }

    protected String[] getChangeFileds() {
        return null;
    }

    protected String[] getChangeEntryFileds() {
        return new String[]{"person", "dpt", "starttime", "endtime", "note"};
    }
}

