/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.opplugin.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.mcm.common.GroupStandardUtils;

public class StrategyBaseDataValidator
extends AbstractValidator {
    private Map<Long, Long> groupCreateOrgMap = new HashMap<Long, Long>(1024);
    private Map<Long, Long> supplierGroupCreateOrgMap = new HashMap<Long, Long>(1024);
    private Map<Long, Set<Long>> dataSuperOrgMap = new HashMap<Long, Set<Long>>(1024);
    private Map<Long, Set<Long>> supplierGroupSuperOrgMap = new HashMap<Long, Set<Long>>(1024);
    private Map<Long, String> groupNameMap = new HashMap<Long, String>(1024);
    private Map<Long, Long> materialGroupMap = new HashMap<Long, Long>(1024);
    private Map<Long, Long> supplierToGroupMap = new HashMap<Long, Long>(1024);
    private DynamicObject materialGroupStandard = null;
    private DynamicObject customerGroupStandard = null;

    public void validate() {
        DynamicObjectCollection rows;
        ExtendedDataEntity[] dataEntities;
        HashSet<Long> createOrgs = new HashSet<Long>(1024);
        HashSet<Long> groupIds = new HashSet<Long>(1024);
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> supplierIds = new HashSet<Long>(1024);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            Object createOrg = dy.get("org");
            Long createOrgId = GroupStandardUtils.getDataByType(createOrg);
            rows = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                Object supplier;
                Long supplierId;
                Object category = row.get("category");
                Object material = row.get("material");
                boolean hasSupplier = row.getDynamicObjectType().getProperties().containsKey((Object)"supplier");
                if (hasSupplier && (supplierId = GroupStandardUtils.getDataByType(supplier = row.get("supplier"))) != null) {
                    supplierIds.add(supplierId);
                }
                Long categoryId = GroupStandardUtils.getDataByType(category);
                Long materialId = GroupStandardUtils.getDataByType(material);
                createOrgs.add(createOrgId);
                String type = null;
                type = StringUtils.equals((CharSequence)"mcm_supplyrate", (CharSequence)this.entityKey) ? dy.getString("strategytype") : row.getString("type");
                if ("1".equals(type) && categoryId != null) {
                    groupIds.add(categoryId);
                    continue;
                }
                if (!"2".equals(type) || materialId == null) continue;
                materialIds.add(materialId);
            }
        }
        this.loadMaterialAndGroupInfo(materialIds, groupIds, createOrgs);
        if (supplierIds.size() > 0) {
            this.loadSupplierAndGroupInfo(supplierIds, createOrgs);
        }
        String materialGroupStandardName = this.getMaterialGroupStandardName();
        String supplierGroupStandardName = this.getSupplierGroupStandardName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            rows = dy.getDynamicObjectCollection("entryentity");
            Object createOrg = dy.get("org");
            Long createOrgId = GroupStandardUtils.getDataByType(createOrg);
            for (DynamicObject row : rows) {
                this.validateCategory(dataEntity, dy, row, createOrgId, materialGroupStandardName);
                if (supplierIds.size() <= 0) continue;
                this.validateSupplier(dataEntity, dy, row, createOrgId, supplierGroupStandardName);
            }
        }
    }

    private void validateSupplier(ExtendedDataEntity dataEntity, DynamicObject dy, DynamicObject row, Long createOrgId, String supplierGroupStandardName) {
        Object supplier = row.get("supplier");
        Long supplierId = GroupStandardUtils.getDataByType(supplier);
        if (supplier == null && StringUtils.equals((CharSequence)"mcm_supplyrate", (CharSequence)this.entityKey)) {
            return;
        }
        if (supplier == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\uff0c\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SupplyLayoutSubmitValidator_7", (String)"scm-mcm", (Object[])new Object[0]), row.get("seq"), this.getEntryName()));
            return;
        }
        Long groupId = this.supplierToGroupMap.get(supplierId);
        Long storeOrgId = this.supplierGroupCreateOrgMap.get(groupId);
        Set<Long> supOrgIds = this.supplierGroupSuperOrgMap.get(createOrgId);
        if (supOrgIds == null || !supOrgIds.contains(storeOrgId)) {
            String message = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u7ec4\u7ec7\u7684%3$s\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"StrategyBaseDataValidator_0", (String)"scm-mcm", (Object[])new Object[0]), row.get("supplier.name"), dy.getString("org.name"), supplierGroupStandardName);
            this.addErrorMessage(dataEntity, message);
        }
    }

    private void validateCategory(ExtendedDataEntity dataEntity, DynamicObject dy, DynamicObject row, Long createOrgId, String materialGroupStandardName) {
        Object category = row.get("category");
        Object material = row.get("material");
        Long materialId = GroupStandardUtils.getDataByType(material);
        Long groupId = GroupStandardUtils.getDataByType(category);
        String type = null;
        type = StringUtils.equals((CharSequence)"mcm_supplyrate", (CharSequence)this.entityKey) ? dy.getString("strategytype") : row.getString("type");
        String message = "";
        String message1 = "";
        if ("1".equals(type)) {
            if (category == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\uff0c\u8bf7\u9009\u62e9\u54c1\u7c7b\u3002", (String)"SupplyLayoutSubmitValidator_2", (String)"scm-mcm", (Object[])new Object[0]), row.get("seq"), this.getEntryName()));
                return;
            }
            message = String.format(ResManager.loadKDString((String)"\u54c1\u7c7b\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u7ec4\u7ec7\u7684%3$s\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"StrategyBaseDataValidator_2", (String)"scm-mcm", (Object[])new Object[0]), row.getString("category.name"), dy.getString("org.name"), materialGroupStandardName);
            message1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%1$s\u201d\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", (String)"StrategyBaseDataValidator_3", (String)"scm-mcm", (Object[])new Object[0]), this.groupNameMap.get(groupId));
        } else if ("2".equals(type)) {
            if (material == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\uff0c\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"SupplyLayoutSubmitValidator_1", (String)"scm-mcm", (Object[])new Object[0]), row.get("seq"), this.getEntryName()));
                return;
            }
            groupId = this.materialGroupMap.get(materialId);
            message = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u7ec4\u7ec7\u7684%3$s\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"StrategyBaseDataValidator_5", (String)"scm-mcm", (Object[])new Object[0]), row.getString("category.name"), dy.getString("org.name"), materialGroupStandardName);
            message1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u201c%1$s\u201d\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", (String)"StrategyBaseDataValidator_6", (String)"scm-mcm", (Object[])new Object[0]), this.groupNameMap.get(groupId));
        }
        Long storeOrgId = this.groupCreateOrgMap.get(groupId);
        if (storeOrgId == null) {
            this.addErrorMessage(dataEntity, message);
        } else {
            Set<Long> supOrgIds = this.dataSuperOrgMap.get(createOrgId);
            if (supOrgIds == null || !supOrgIds.contains(storeOrgId)) {
                this.addErrorMessage(dataEntity, message1);
            }
        }
    }

    private void loadSupplierAndGroupInfo(Set<Long> supplierIds, Set<Long> createOrgs) {
        HashSet<Long> groupIds = new HashSet<Long>(1024);
        if (supplierIds.size() > 0) {
            QFilter mQfilter = new QFilter("supplier", "in", supplierIds);
            mQfilter.and("standard", "=", (Object)this.getSupplierGroupStandardId());
            Map materialGroupDetails = BusinessDataServiceHelper.loadFromCache((String)"bd_suppliergroupdetail", (String)"standard,group,createorg,supplier", (QFilter[])new QFilter[]{mQfilter});
            for (DynamicObject value : materialGroupDetails.values()) {
                Long material = GroupStandardUtils.getDataByType(value.get("supplier"));
                Long group = GroupStandardUtils.getDataByType(value.get("group"));
                this.supplierToGroupMap.put(material, group);
                groupIds.add(group);
            }
            QFilter qFilter = new QFilter("id", "in", groupIds);
            qFilter.and("standard", "=", (Object)this.getSupplierGroupStandardId());
            Map storeGroups = BusinessDataServiceHelper.loadFromCache((String)"bd_suppliergroup", (String)"createorg,name,enable,standard", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject value : storeGroups.values()) {
                Object createOrg = value.get("createorg");
                Object id = value.get("id");
                Long orgId = GroupStandardUtils.getDataByType(createOrg);
                Long groupId = GroupStandardUtils.getDataByType(id);
                this.supplierGroupCreateOrgMap.put(groupId, orgId);
            }
            this.supplierGroupSuperOrgMap.putAll(GroupStandardUtils.getGroupOrgMap("bd_suppliergroup", createOrgs));
        }
    }

    private void loadMaterialAndGroupInfo(Set<Long> materialIds, Set<Long> groupIds, Set<Long> createOrgs) {
        if (materialIds.size() > 0) {
            QFilter mQfilter = new QFilter("material", "in", materialIds);
            mQfilter.and("standard", "=", (Object)this.getMaterialGroupStandardId());
            Map materialGroupDetails = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"standard,group,createorg,material", (QFilter[])new QFilter[]{mQfilter});
            for (DynamicObject value : materialGroupDetails.values()) {
                Long material = GroupStandardUtils.getDataByType(value.get("material"));
                Long group = GroupStandardUtils.getDataByType(value.get("group"));
                this.materialGroupMap.put(material, group);
                groupIds.add(group);
            }
        }
        QFilter qFilter = new QFilter("id", "in", groupIds);
        qFilter.and("standard", "=", (Object)this.getMaterialGroupStandardId());
        Map storeGroups = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"createorg,name,enable,standard", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject value : storeGroups.values()) {
            Object createOrg = value.get("createorg");
            Object id = value.get("id");
            Long orgId = GroupStandardUtils.getDataByType(createOrg);
            Long groupId = GroupStandardUtils.getDataByType(id);
            this.groupCreateOrgMap.put(groupId, orgId);
            this.groupNameMap.put(groupId, value.getLocaleString("name") == null ? "" : value.getLocaleString("name").getLocaleValue());
        }
        this.dataSuperOrgMap.putAll(GroupStandardUtils.getGroupOrgMap("bd_materialgroup", createOrgs));
    }

    private Long getMaterialGroupStandardId() {
        if (this.materialGroupStandard == null) {
            this.materialGroupStandard = this.loadMaterialGroupStandard();
        }
        return this.materialGroupStandard == null ? BillAssistConstant.MATERIAL_STANDARD_ID.longValue() : this.materialGroupStandard.getLong("id");
    }

    private String getMaterialGroupStandardName() {
        if (this.materialGroupStandard == null) {
            this.materialGroupStandard = this.loadMaterialGroupStandard();
        }
        return this.materialGroupStandard == null ? ResManager.loadKDString((String)"\u57fa\u672c\u5206\u7c7b\u6807\u51c6", (String)"StrategyBaseDataValidator_7", (String)"scm-mcm", (Object[])new Object[0]) : this.materialGroupStandard.getString("name");
    }

    private DynamicObject loadMaterialGroupStandard() {
        Long materialGroupType = GroupStandardUtils.getMaterialGroupType("mcm");
        return QueryServiceHelper.queryOne((String)"bd_materialgroupstandard", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialGroupType)});
    }

    private Long getSupplierGroupStandardId() {
        if (this.customerGroupStandard == null) {
            this.customerGroupStandard = this.loadSupplierGroupStandard();
        }
        return this.customerGroupStandard == null ? BillAssistConstant.GROUP_STANDARD_ID.longValue() : this.customerGroupStandard.getLong("id");
    }

    private String getSupplierGroupStandardName() {
        if (this.customerGroupStandard == null) {
            this.customerGroupStandard = this.loadSupplierGroupStandard();
        }
        return this.customerGroupStandard == null ? ResManager.loadKDString((String)"\u57fa\u672c\u5206\u7c7b\u6807\u51c6", (String)"StrategyBaseDataValidator_7", (String)"scm-mcm", (Object[])new Object[0]) : this.customerGroupStandard.getString("name");
    }

    private DynamicObject loadSupplierGroupStandard() {
        Long supplierGroupType = GroupStandardUtils.getSupplierGroupType();
        return QueryServiceHelper.queryOne((String)"bd_suppliergroupstandard", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierGroupType)});
    }

    private String getEntryName() {
        return "mcm_differentiation_plan".equals(this.entityKey) ? ResManager.loadKDString((String)"\u7b56\u7565\u6267\u884c\u8be6\u60c5", (String)"SupplyLayoutSubmitValidator_3", (String)"scm-mcm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b56\u7565\u4fe1\u606f", (String)"SupplyLayoutSubmitValidator_4", (String)"scm-mcm", (Object[])new Object[0]);
    }
}

