/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.opplugin.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StrategyLayDownSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> dumSourceMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            long sourcebill = info.getLong("sourcebill");
            if (sourcebill != 0L) {
                ExtendedDataEntity entity = (ExtendedDataEntity)dumSourceMap.get(dataEntity);
                if (entity != null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7248\u672c\u7684\u7b56\u7565\u53d8\u66f4\u5355\u3002", (String)"StrategyLayDownSubmitValidator_1", (String)"scm-mcm", (Object[])new Object[0]));
                } else {
                    dumSourceMap.put(sourcebill, dataEntity);
                }
            }
            DynamicObjectCollection orgs = info.getDynamicObjectCollection("entryentityorg");
            HashSet<Long> orgIds = new HashSet<Long>();
            for (DynamicObject org : orgs) {
                if (orgIds.contains(org.getLong("exeorg_id"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u6267\u884c\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u8bf7\u5904\u7406\u3002", (String)"StrategyLayDownSubmitValidator_0", (String)"scm-mcm", (Object[])new Object[0]), org.getString("exeorg.name")));
                }
                orgIds.add(org.getLong("exeorg_id"));
            }
        }
        Set dumSourceBillIds = dumSourceMap.keySet();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityKey, (String)"id,billno,sourcebill", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", dumSourceBillIds)}, null);){
            for (Row row : dataSet) {
                ExtendedDataEntity entity = (ExtendedDataEntity)dumSourceMap.get(row.getLong("sourcebill"));
                long strategyId = row.getLong("id");
                long billPkId = entity.getDataEntity().getLong("id");
                if (entity == null || billPkId != 0L && (billPkId == 0L || billPkId == strategyId)) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7248\u672c\u7684\u7b56\u7565\u53d8\u66f4\u5355\u3002", (String)"StrategyLayDownSubmitValidator_1", (String)"scm-mcm", (Object[])new Object[0]));
            }
        }
    }
}

