/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.opplugin.validate;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SupplyLayoutSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            HashSet<String> dumpKeys = new HashSet<String>();
            DynamicObject row = dataEntity.getDataEntity();
            this.validateDiffInfo(dataEntity);
            DynamicObjectCollection entryentity = row.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                String type = dynamicObject.getString("type");
                if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
                    DynamicObject category = dynamicObject.getDynamicObject("category");
                    if (category == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\uff0c\u8bf7\u9009\u62e9\u54c1\u7c7b\u3002", (String)"SupplyLayoutSubmitValidator_2", (String)"scm-mcm", (Object[])new Object[0]), dynamicObject.get("seq"), this.getEntryName()));
                    }
                } else {
                    DynamicObject material = dynamicObject.getDynamicObject("material");
                    if (material == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\uff0c\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"SupplyLayoutSubmitValidator_1", (String)"scm-mcm", (Object[])new Object[0]), dynamicObject.get("seq"), this.getEntryName()));
                    }
                }
                String dumpKey = this.makeRowKey(dynamicObject);
                if (dumpKeys.contains(dumpKey)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5185\u5bb9\u76f8\u540c\uff0c\u8bf7\u5904\u7406\u3002", (String)"SupplyLayoutSubmitValidator_0", (String)"scm-mcm", (Object[])new Object[0]), dynamicObject.get("seq"), this.getEntryName()));
                    continue;
                }
                dumpKeys.add(dumpKey);
            }
        }
    }

    private void validateDiffInfo(ExtendedDataEntity dataEntity) {
        if ("mcm_differentiation_plan".equals(this.entityKey)) {
            StringBuilder builder;
            DynamicObject diffPlan = dataEntity.getDataEntity();
            DynamicObjectCollection strategyinfo = diffPlan.getDynamicObjectCollection("strategyinfo");
            DynamicObjectCollection entryentity = diffPlan.getDynamicObjectCollection("entryentity");
            HashSet<String> entryStrategys = new HashSet<String>(entryentity.size());
            LinkedHashMap<String, Integer> strategySeqMap = new LinkedHashMap<String, Integer>(strategyinfo.size());
            for (DynamicObject info : strategyinfo) {
                builder = new StringBuilder();
                builder.append(info.getString("categorylevel_stgy_id"));
                builder.append("-");
                builder.append(info.getString("policytype_stgy"));
                strategySeqMap.put(builder.toString(), info.getInt("seq"));
            }
            for (DynamicObject info : entryentity) {
                builder = new StringBuilder();
                builder.append(info.getString("categorylevel_id"));
                builder.append("-");
                builder.append(info.getString("policytype"));
                entryStrategys.add(builder.toString());
            }
            for (Map.Entry next : strategySeqMap.entrySet()) {
                if (entryStrategys.contains(next.getKey())) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7b56\u7565\u4fe1\u606f\u201d\u9875\u7b7e\u4e2d\u7b2c%1$s\u884c\u7684\u5185\u5bb9\u6ca1\u6709\u6dfb\u52a0\u5230\u201c\u7b56\u7565\u6267\u884c\u8be6\u60c5\u201d\u9875\u7b7e\u4e2d\uff0c\u8bf7\u5bf9\u5e94\u589e\u884c\u6dfb\u52a0\u3002", (String)"SupplyLayoutSubmitValidator_5", (String)"scm-mcm", (Object[])new Object[0]), next.getValue()));
            }
        }
    }

    private String makeRowKey(DynamicObject dynamicObject) {
        StringBuilder builder = new StringBuilder();
        String entityKey = this.getEntityKey();
        if ("mcm_supplylayout".equals(entityKey)) {
            builder.append(dynamicObject.getString("strategytype"));
            builder.append("-");
        }
        builder.append(dynamicObject.getString("type"));
        builder.append("-");
        builder.append(dynamicObject.getString("category_id"));
        builder.append("-");
        builder.append(dynamicObject.getString("material_id"));
        if (!"mcm_reduce".equals(entityKey)) {
            builder.append("-");
            builder.append(dynamicObject.getString("supplier_id"));
        }
        if ("mcm_differentiation_plan".equals(entityKey)) {
            builder.append("-");
            builder.append(dynamicObject.getString("categorylevel_id"));
            builder.append("-");
            builder.append(dynamicObject.getString("policytype"));
        }
        return builder.toString();
    }

    private String getEntryName() {
        return "mcm_differentiation_plan".equals(this.entityKey) ? ResManager.loadKDString((String)"\u7b56\u7565\u6267\u884c\u8be6\u60c5", (String)"SupplyLayoutSubmitValidator_3", (String)"scm-mcm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b56\u7565\u4fe1\u606f", (String)"SupplyLayoutSubmitValidator_4", (String)"scm-mcm", (Object[])new Object[0]);
    }
}

