/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.report;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.mcm.report.JobReportTransform;
import kd.scm.mcm.report.SupplyLayoutReportParam;

public abstract class AbstractReportHandle
implements IReportDataHandle {
    private SupplyLayoutReportParam reportParam;

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        QFilter generalFs = this.getPageFilter(ctx);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
                srcBlockConf.setDataFs(dataFs);
            }
            if (!this.getSrcEntity().equals(srcEntity)) continue;
            srcBlockConf.getDataFs().and(generalFs);
            dataFs.and(generalFs);
        }
    }

    protected abstract String getSrcEntity();

    protected abstract String getSrcJobEntity();

    protected IDataTransform getTransform(ReportDataCtx ctx) {
        return new JobReportTransform(ctx, this.getSrcJobEntity());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(this.getTransform(ctx));
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.putIfAbsent("strategyid", "id");
        Map repoColSrcColMap = blockConf.getRepoColSrcColMap();
        repoColSrcColMap.putIfAbsent("strategyid", "strategyid");
    }

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (SupplyLayoutReportParam)ctx.getParam(SupplyLayoutReportParam.class.getName());
    }

    private void setBaseDataHeadFilter(QFilter qFilter, ReportDataCtx ctx) {
        List headFilters = (List)ctx.getParam("headfilter");
        if (headFilters == null || headFilters.isEmpty()) {
            return;
        }
        for (QFilter headFilter : headFilters) {
            if ("createorg".equals(headFilter.getProperty())) {
                headFilter.__setProperty("org.name");
            } else if ("exeorg".equals(headFilter.getProperty())) {
                headFilter.__setProperty("entryentityorg.exeorg.name");
            } else if ("strategyname".equals(headFilter.getProperty())) {
                headFilter.__setProperty("name");
            }
            qFilter.and(headFilter);
        }
    }

    private QFilter getPageFilter(ReportDataCtx ctx) {
        String name;
        String year;
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(new QFilter("org", "in", this.reportParam.getCreateorgs()));
        List<Long> exeorgIds = this.reportParam.getExeorg();
        if (exeorgIds != null && !exeorgIds.isEmpty()) {
            qFilter.and(new QFilter("entryentityorg.exeorg", "in", exeorgIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)(year = this.reportParam.getYear()))) {
            qFilter.and(new QFilter("year", "=", (Object)year));
        }
        if ((name = this.reportParam.getName()) != null) {
            qFilter.and(new QFilter("name", "=", (Object)name));
        }
        this.setBaseDataHeadFilter(qFilter, ctx);
        qFilter.and(new QFilter("isuse", "=", (Object)"1"));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        return qFilter;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        ReportColumn reportCol = null;
        String field = null;
        for (AbstractReportColumn col : columns) {
            reportCol = (ReportColumn)col;
            field = reportCol.getFieldKey();
            if (!"totalcount".equals(field) && !"doingcount".equals(field) && !"submitcount".equals(field) && !"auditedcount".equals(field) && !"rejectcount".equals(field) && !"chutcount".equals(field)) continue;
            ((ReportColumn)col).setHyperlink(true);
        }
        return columns;
    }
}

