/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.report;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;

public class JobReportTransform
implements IDataTransform {
    private String srcEntity;
    private ReportDataCtx ctx;

    public JobReportTransform(ReportDataCtx ctx, String srcEntity) {
        this.srcEntity = srcEntity;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet doTransform(DataSet srcData) {
        HashSet<Long> billIds = new HashSet<Long>();
        try (DataSet dataset = srcData.copy();){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                billIds.add(row.getLong("strategyid"));
            }
        }
        if (billIds.size() == 0) {
            return srcData;
        }
        DataSet finish = null;
        DataSet orderDataSet = null;
        GroupbyDataSet groupby = null;
        try {
            Set jobShowColset = this.ctx.getShowQtyCols();
            Set billShowColset = this.ctx.getShowKeyCols();
            QFilter jobQFilter = new QFilter("strategyid", "in", billIds);
            orderDataSet = QueryServiceHelper.queryDataSet((String)"queryOrder", (String)this.srcEntity, (String)("org.id as org, strategyid," + this.getcountselector()), (QFilter[])jobQFilter.toArray(), null);
            String[] jobShowCols = jobShowColset.toArray(new String[0]);
            String[] billShowCols = billShowColset.toArray(new String[0]);
            if (orderDataSet.hasNext()) {
                srcData.leftJoin(orderDataSet).on("strategyid", "strategyid").select(billShowCols, jobShowCols);
                finish = srcData.leftJoin(orderDataSet).on("strategyid", "strategyid").on("exeorg", "org").select(billShowCols, jobShowCols).finish();
                groupby = finish.groupBy(billShowCols);
                groupby = groupby.sum("totalcount", "totalcount").sum("doingcount", "doingcount").sum("submitcount", "submitcount").sum("auditedcount", "auditedcount").sum("rejectcount", "rejectcount").sum("chutcount", "chutcount");
                srcData = groupby.finish();
                String sort = (String)this.ctx.getParam("headsort");
                srcData = StringUtils.isEmpty((String)sort) ? srcData.orderBy(new String[]{"createtime desc ", "strategyid"}) : srcData.orderBy(sort.split(","));
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
            if (orderDataSet != null) {
                orderDataSet.close();
            }
        }
        return srcData;
    }

    private String getcountselector() {
        StringBuilder selector = new StringBuilder();
        selector.append(" 1 as totalcount,");
        selector.append(" (case when jobstatus = 'A' or jobstatus =' ' then 1 else 0 end ) as doingcount,");
        selector.append(" (case when jobstatus = 'B' then 1 else 0 end ) as submitcount, ");
        selector.append(" (case when jobstatus = 'C'  then 1 else 0 end ) as auditedcount,");
        selector.append("( case when jobstatus = 'D' then 1 else 0 end )as rejectcount,");
        selector.append(" (case when jobstatus = 'E' then 1 else 0 end ) as chutcount ");
        return selector.toString();
    }
}

