/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mcm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mcm.common.StrategyLayDownHelper;
import kd.scm.mcm.report.SupplyLayoutReportParam;

public class StrategyReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void initialize() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("name");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit corg = (BasedataEdit)this.getView().getControl("corg");
        corg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList grid = (ReportList)this.getView().getControl("reportlistap");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean flag = super.verifyQuery(queryParam);
        if (!flag) {
            return false;
        }
        FilterInfo filter = queryParam.getFilter();
        String createorg = filter.getString("corg");
        if (StringUtils.isEmpty((CharSequence)createorg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"SupplyLayoutReportTransform_0", (String)"scm-mcm", (Object[])new Object[0]));
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        SupplyLayoutReportParam orderParam = this.buildRptParam();
        param.getCustomParam().put(SupplyLayoutReportParam.class.getName(), orderParam);
        return true;
    }

    public SupplyLayoutReportParam buildRptParam() {
        List<Long> mexeorgs;
        IDataModel model = this.getModel();
        SupplyLayoutReportParam reportParam = new SupplyLayoutReportParam();
        reportParam.setCreateorgs(this.getBaseDataIds("corg"));
        if (null != model.getValue("name")) {
            String name = ((DynamicObject)model.getValue("name")).get("name").toString();
            reportParam.setName(name);
        }
        if (!(mexeorgs = this.getBaseDataIds("mexeorg")).isEmpty()) {
            reportParam.setExeorg(mexeorgs);
        }
        if (null != model.getValue("year")) {
            reportParam.setYear(model.getValue("year").toString());
        }
        return reportParam;
    }

    public List<Long> getBaseDataIds(String filedname) {
        DynamicObjectCollection dys = (DynamicObjectCollection)this.getModel().getValue(filedname);
        ArrayList<Long> ids = new ArrayList<Long>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(Long.parseLong(((DynamicObject)dy.get("fbasedataid")).getPkValue().toString()));
            }
        }
        return ids;
    }

    public void afterCreateNewData(EventObject e) {
        List comboItems;
        super.afterCreateNewData(e);
        DynamicProperty year = this.getView().getModel().getDataEntity().getDynamicObjectType().getProperty("year");
        String defaultValue = "2023";
        if (year instanceof ComboProp && (comboItems = ((ComboProp)year).getComboItems()).size() > 0) {
            ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(0);
            defaultValue = valueMapItem.getValue();
        }
        this.getView().getPageCache().put("year", defaultValue);
        this.setYearItemInfo();
        Long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("corg", (Object)new Object[]{orgId});
    }

    private void setYearItemInfo() {
        List comboItems;
        ComboEdit comboEdit = (ComboEdit)this.getControl("year");
        IDataEntityProperty property = comboEdit.getProperty();
        String firstItem = this.getView().getPageCache().get("year");
        if (property instanceof ComboProp && (comboItems = ((ComboProp)property).getComboItems()).size() > 0) {
            firstItem = ((ValueMapItem)comboItems.get(0)).getValue();
        }
        comboItems = StrategyLayDownHelper.getYearComboItem(firstItem);
        comboEdit.setComboItems(comboItems);
        Calendar instance = Calendar.getInstance();
        instance.setTime(TimeServiceHelper.now());
        int endYear = instance.get(1);
        this.getView().getModel().setValue("year", (Object)String.valueOf(endYear));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListFilterParameter showParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        if ("corg".equals(fieldKey)) {
            String entity = this.getView().getEntityId();
            HasPermOrgResult permissionOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"32WSHW0OE+O7", (String)entity, (String)"47150e89000000ac", (boolean)true);
            if (!permissionOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = permissionOrgs.getHasPermOrgs();
                showParameter.setFilter(new QFilter("id", "in", (Object)hasPermOrgs));
            }
        } else if ("name".equals(fieldKey)) {
            List<Long> ids = this.getBaseDataIds("corg");
            if (ids == null || ids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"SupplyLayoutReportTransform_0", (String)"scm-mcm", (Object[])new Object[0]));
                e.setCancel(true);
            }
            showParameter.setFilter(new QFilter("createorg", "in", ids));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String field = e.getFieldName();
        if ("totalcount".equals(field) || "doingcount".equals(field) || "submitcount".equals(field) || "auditedcount".equals(field) || "rejectcount".equals(field) || "chutcount".equals(field)) {
            this.showDetailRpt(e, field);
        }
    }

    private void showDetailRpt(HyperLinkClickEvent e, String field) {
        String entity = this.getView().getEntityId();
        String fomid = StrategyReportPlugin.getJobByReport(entity);
        int index = e.getRowIndex();
        ReportList grid = (ReportList)this.getView().getControl("reportlistap");
        DynamicObject data = grid.getReportModel().getRowData(index);
        if (data != null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("isfromreport", true);
            long strategyid = data.getLong("strategyid");
            String key = strategyid + field;
            QFilter qFilter = new QFilter("strategyid", "=", (Object)strategyid);
            paramMap.put("strategyid", strategyid);
            Object exeorg = null;
            int haspermission = 1;
            if (null != data.get("exeorg") && data.getDynamicObject("exeorg").getPkValue() != null) {
                exeorg = data.getDynamicObject("exeorg").getPkValue();
                paramMap.put("org.id", exeorg);
                qFilter.and(new QFilter("org.id", "=", exeorg));
                key = key + data.getDynamicObject("exeorg").getPkValue();
                haspermission = PermissionServiceHelper.checkFunctionPermission((long)RequestContext.get().getCurrUserId(), (long)Long.parseLong(exeorg.toString()), (String)fomid, (String)"47150e89000000ac");
            }
            String formname = MetadataServiceHelper.getDataEntityType((String)fomid).getDisplayName().getLocaleValue();
            if (haspermission == 0) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StrategyReportPlugin_1", (String)"scm-mcm", (Object[])new Object[]{formname});
                this.getView().showMessage(msg);
                return;
            }
            String jobstatus = null;
            switch (field) {
                case "totalcount": {
                    break;
                }
                case "doingcount": {
                    jobstatus = "A";
                    break;
                }
                case "submitcount": {
                    jobstatus = "B";
                    break;
                }
                case "auditedcount": {
                    jobstatus = "C";
                    break;
                }
                case "rejectcount": {
                    jobstatus = "D";
                    break;
                }
                case "chutcount": {
                    jobstatus = "E";
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)jobstatus)) {
                qFilter.and(new QFilter("jobstatus", "=", (Object)jobstatus));
                paramMap.put("jobstatus", jobstatus);
            }
            paramMap.put("isfromreport", true);
            ListShowParameter lsp = new ListShowParameter();
            lsp.setShowTitle(true);
            lsp.setShowFilter(false);
            lsp.setBillFormId(fomid);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.getListFilterParameter().setFilter(qFilter);
            lsp.setCustomParams(paramMap);
            lsp.setPageId(fomid + key + this.getView().getPageId());
            lsp.addCustPlugin("kd.scm.mcm.report.StrategyPlan4ReportList");
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            String key = event.getColumnName();
            if (!"createorg".equals(key) && !"exeorg".equals(key) && !"strategyname".equals(key) && !"version".equals(key) && !"year".equals(key)) continue;
            event.setSort(true);
            event.setFilter(true);
        }
    }

    public static String getJobByReport(String entity) {
        return StrategyLayDownHelper.getJobByReport(entity);
    }
}

