/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.scm.mobsp.common.entity.configvo.ConfigSearchVo;
import kd.scm.mobsp.common.entity.configvo.TndCompConfigEntryModel;
import kd.scm.mobsp.common.entity.configvo.TndCompConfigModel;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.MobileApiCRUDUtils;

public class SourcingComponentConfigHelper {
    public static Map<String, Boolean> setViewByConfig(IFormView view, Long id, String entityKey, String compKey) {
        HashMap<String, Boolean> viewConfig = new HashMap<String, Boolean>();
        Map<String, ComponentConfig> configs = SourcingComponentConfigHelper.getConfig(id, entityKey, compKey);
        configs.entrySet().forEach(stringQuoteConfigEntry -> {
            ComponentConfig config = (ComponentConfig)stringQuoteConfigEntry.getValue();
            String key = (String)stringQuoteConfigEntry.getKey();
            Control control = view.getControl(key = key.split("\\.")[key.split("\\.").length - 1]);
            if (control == null) {
                control = view.getControl(key + "_id");
            }
            if (control == null) {
                return;
            }
            viewConfig.put(key, config.visible);
            view.setVisible(Boolean.valueOf(config.visible), new String[]{control.getKey()});
            view.setEnable(Boolean.valueOf(config.enable), new String[]{control.getKey()});
            if (!(control instanceof FieldEdit)) {
                return;
            }
            FieldEdit fieldEdit = (FieldEdit)control;
            fieldEdit.setMustInput(config.mustInput);
        });
        return viewConfig;
    }

    private static Map<String, ComponentConfig> getConfig(Long id, String entityKey, String compKey) {
        ConfigSearchVo quoteConfigSearchVo = new ConfigSearchVo();
        quoteConfigSearchVo.setBillId(id);
        quoteConfigSearchVo.setEntityKey(entityKey);
        quoteConfigSearchVo.setCompKey(compKey);
        OpenApiResult openApiResult = MobileApiCRUDUtils.callCRUDApi((Object)quoteConfigSearchVo, (String)"/v2/tnd/tnd_compconfig/getCompConfig", (boolean)false);
        TndCompConfigModel config = (TndCompConfigModel)JsonUtils.deserialize((String)JsonUtils.serialize((Object)openApiResult.getData()), TndCompConfigModel.class);
        List<TndCompConfigEntryModel> configEntry = config.getConfigEntry();
        if (configEntry == null) {
            return new HashMap<String, ComponentConfig>(0);
        }
        HashMap<String, ComponentConfig> map = new HashMap<String, ComponentConfig>(configEntry.size());
        for (TndCompConfigEntryModel entryModel : configEntry) {
            map.put(entryModel.getFieldKey(), new ComponentConfig(entryModel.getVisiable(), entryModel.getMustInput(), entryModel.getEditable()));
        }
        return map;
    }

    public static class ComponentConfig {
        private final boolean visible;
        private final boolean mustInput;
        private final boolean enable;

        public ComponentConfig(boolean visible, boolean mustInput, boolean enable) {
            this.visible = visible;
            this.mustInput = mustInput;
            this.enable = enable;
        }
    }
}

