/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.design.hompage.region;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.mobsp.common.helper.AppHomeQuoNoticeHelper;
import kd.scm.mobsp.plugin.form.scp.apphome.AppHomeNewPlugin;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionSingleRegion;
import kd.scmc.msmob.pojo.CardData;

public class MobspQuoNoticeRegion
extends CheckPermissionSingleRegion {
    private static final Log LOG = LogFactory.getLog(AppHomeNewPlugin.class);
    private static final String BILLDATE = "billdate";
    private static final String QUO = "quo";
    private static final String QUO_NOTICE = "quo_notice";

    public MobspQuoNoticeRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public MobspQuoNoticeRegion(IFormView view) {
        super(null, null, null, view);
    }

    public Boolean singleCheckPermission() {
        return PermissionHelper.userHasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)QUO, (String)QUO_NOTICE, (String)"47150e89000000ac");
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        if (this.isPresent(setting) && this.singleCheckPermission().booleanValue()) {
            this.setQuoNoticeVisible();
        }
    }

    public void buildCardData(CardData setting, IFormView view, Boolean isPresent) {
        super.buildCardData(setting, view, isPresent);
        Boolean isPermission = this.singleCheckPermission();
        if (!isPermission.booleanValue()) {
            setting.getSelectedCards().removeIf(card -> card.getId().equals(this.getRegionId()));
            setting.getNotSelectedCards().removeIf(card -> card.getId().equals(this.getRegionId()));
        }
    }

    private void setQuoNoticeVisible() {
        List quoFilter = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)QUO, (String)"IQuoFilterService", (String)"getNoticeListFilter", (Object[])new Object[0]);
        LOG.info(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u516c\u544a\u67e5\u8be2\u8fc7\u6ee4\u63a5\u53e3\uff1a\u3010{}\u3011", (String)"AppHomeNewPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]), (Object)quoFilter);
        Date startDate = (Date)this.getView().getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("todobusiness_enddate");
        QFilter qFilter = new QFilter(BILLDATE, ">=", (Object)startDate);
        qFilter.and(new QFilter(BILLDATE, "<=", (Object)endDate));
        quoFilter.add(qFilter);
        DynamicObject[] queryQuoNotice = AppHomeQuoNoticeHelper.getQueryQuoNotice(QUO_NOTICE, quoFilter);
        this.setQuoNoticeEntry(queryQuoNotice);
    }

    private void setQuoNoticeEntry(DynamicObject[] quoNoticeResult) {
        IDataModel model = this.getView().getModel();
        if (quoNoticeResult != null && quoNoticeResult.length != 0) {
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", quoNoticeResult.length);
            model.beginInit();
            for (int i = 0; i < quoNoticeResult.length; ++i) {
                model.setValue("mobid", quoNoticeResult[i].get("id"), i);
                model.setValue("billstatus", quoNoticeResult[i].get("billstatus"), i);
                model.setValue("billno", quoNoticeResult[i].get("billno"), i);
                model.setValue("noticetitle", quoNoticeResult[i].get("noticetitle"), i);
                model.setValue("quoorg", quoNoticeResult[i].get("org"), i);
                model.setValue("biztime", quoNoticeResult[i].get(BILLDATE), i);
                model.setValue("biztype", quoNoticeResult[i].get("biztype"), i);
                model.setValue("istop", (Object)quoNoticeResult[i].getBoolean("istop"), i);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        } else {
            model.deleteEntryData("entryentity");
        }
    }
}

