/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.design.hompage.region;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.scm.mobsp.common.helper.AppHomeToDoBusinessHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionMultipleRegion;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.ControlPermInfo;
import kd.scmc.msmob.pojo.PermItemInfo;

public class MobspToDoBusinessRegion
extends CheckPermissionMultipleRegion {
    private static final String QUO = "quo";
    private static final String SCP = "scp";

    public MobspToDoBusinessRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setToDoBusinessCard();
    }

    public void setToDoBusinessCard() {
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<String> entityNames = new ArrayList<String>(2);
        entityNames.add("scp_order");
        entityNames.add("quo_inquiry");
        this.setCountAndVisible(entityNames, currUserId);
    }

    private void setCountAndVisible(List<String> entityNames, long currUserId) {
        Date startDate = (Date)this.getView().getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("todobusiness_enddate");
        Label scpPurOrderLab = (Label)this.getView().getControl("submitpurordercount");
        Label scpDeliverNoticeLab = (Label)this.getView().getControl("submitdelivernoticecount");
        Label scpQuoteInputLab = (Label)this.getView().getControl("submitquoteinputcount");
        Iterator<String> iterator = entityNames.iterator();
        while (iterator.hasNext()) {
            String entityName;
            switch (entityName = iterator.next()) {
                case "scp_order": {
                    AppHomeToDoBusinessHelper.setNotConfirmOrderCount(scpPurOrderLab, startDate, endDate, SCP, currUserId, entityName);
                    AppHomeToDoBusinessHelper.setNotDeliverOrderCount(scpDeliverNoticeLab, startDate, endDate, SCP, currUserId, entityName);
                    break;
                }
                case "quo_inquiry": {
                    AppHomeToDoBusinessHelper.setNotQuoteInPutCount(scpQuoteInputLab, QUO, currUserId, entityName);
                    break;
                }
            }
        }
    }

    public Map<String, Boolean> checkPermission() {
        HashMap<String, Boolean> checkResult = new HashMap<String, Boolean>(4);
        for (ControlPermInfo controlPermItem : this.getControlPermItems()) {
            controlPermItem.getOpPermItemList().forEach(opItem -> opItem.getPermItemIds().forEach(permItem -> {
                boolean hasPermission = PermissionHelper.userHasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)SCP, (String)opItem.getEntityKey(), (String)"47150e89000000ac");
                checkResult.put(controlPermItem.getControlKey(), hasPermission);
            }));
        }
        return checkResult;
    }

    public List<ControlPermInfo> getControlPermItems() {
        return Stream.of(new ControlPermInfo("submitpurorderflex", null, Stream.of(new PermItemInfo("scp_order", Collections.singletonList("47150e89000000ac"))).collect(Collectors.toList())), new ControlPermInfo("submitdelivernoticeflex", null, Stream.of(new PermItemInfo("scp_order", Collections.singletonList("47150e89000000ac"))).collect(Collectors.toList())), new ControlPermInfo("submitquoteinputflex", null, Stream.of(new PermItemInfo("quo_inquiry", Collections.singletonList("47150e89000000ac"))).collect(Collectors.toList()))).collect(Collectors.toList());
    }
}

