/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mobsp.common.enums.ConfirmStatusEnum;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.enums.BillStatusEnum;

public class AppHomeToDoBusinessHelper {
    public static final Log LOG = LogFactory.getLog(AppHomeToDoBusinessHelper.class);
    private static final String BILLDATE = "billdate";

    public static boolean setNotQuoteInPutCount(Label label, String appId, long currUserId, String entityName) {
        boolean isPermission = PermissionHelper.userHasSpecificPerm((long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (isPermission) {
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"getInquiryTodoInfos", (Object[])new Object[0]);
            LOG.info(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u5f85\u62a5\u4ef7\u670d\u52a1\uff1a\u3010{}\u3011", (String)"AppHomeToDoBusinessHelper_0", (String)"scm-mobsp-form", (Object[])new Object[0]), (Object)resultMap);
            Set toQuoInquiryIds = (Set)resultMap.get("ids1");
            label.setText(String.valueOf(toQuoInquiryIds.size()));
        }
        return isPermission;
    }

    public static boolean setNotConfirmOrderCount(Label label, Date startDate, Date endDate, String appId, long currUserId, String entityName) {
        boolean hasPermission = PermissionHelper.userHasSpecificPerm((long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (hasPermission) {
            List<Long> hasViewPermOrgIds = AppHomeToDoBusinessHelper.getHasViewPermOrgIds(currUserId, appId, entityName);
            ArrayList emptyFilters = new ArrayList(10);
            List qFilters = ScpCoreListFilterHelper.setFilter(emptyFilters);
            List supPersonFilters = ScpBillOfBizPersonFilter.orderFilter();
            supPersonFilters.add(new QFilter("org.id", "in", hasViewPermOrgIds));
            supPersonFilters.add(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getValue()));
            supPersonFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            supPersonFilters.add(new QFilter(BILLDATE, ">=", (Object)startDate));
            supPersonFilters.add(new QFilter(BILLDATE, "<=", (Object)endDate));
            qFilters.addAll(supPersonFilters);
            LOG.info(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4\u8ba2\u5355\u8fc7\u6ee4\u6761\u4ef6\u65e5\u5fd7\uff1a\u3010{}\u3011", (String)"AppHomeToDoBusinessHelper_1", (String)"scm-mobsp-form", (Object[])new Object[0]), (Object)qFilters);
            int count = AppHomeToDoBusinessHelper.getBillCount("scp_order", qFilters);
            label.setText(String.valueOf(count));
        }
        return hasPermission;
    }

    public static boolean setNotDeliverOrderCount(Label label, Date startDate, Date endDate, String appId, long currUserId, String entityName) {
        boolean hasPermission = PermissionHelper.userHasSpecificPerm((long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (hasPermission) {
            List<Long> hasViewPermOrgIds = AppHomeToDoBusinessHelper.getHasViewPermOrgIds(currUserId, appId, entityName);
            ArrayList emptyFilters = new ArrayList(10);
            List qFilters = ScpCoreListFilterHelper.setFilter(emptyFilters);
            List supPersonFilters = ScpBillOfBizPersonFilter.orderFilter();
            supPersonFilters.add(new QFilter("org.id", "in", hasViewPermOrgIds));
            supPersonFilters.add(new QFilter("logstatus", "=", (Object)"A"));
            supPersonFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            supPersonFilters.add(new QFilter(BILLDATE, ">=", (Object)startDate));
            supPersonFilters.add(new QFilter(BILLDATE, "<=", (Object)endDate));
            qFilters.addAll(supPersonFilters);
            LOG.info(ResManager.loadKDString((String)"\u5f85\u53d1\u8d27\u8ba2\u5355\u8fc7\u6ee4\u6761\u4ef6\u65e5\u5fd7\uff1a\u3010{}\u3011", (String)"AppHomeToDoBusinessHelper_2", (String)"scm-mobsp-form", (Object[])new Object[0]), (Object)qFilters);
            int count = AppHomeToDoBusinessHelper.getBillCount("scp_order", qFilters);
            label.setText(String.valueOf(count));
        }
        return hasPermission;
    }

    private static int getBillCount(String entityName, List<QFilter> billCountFilter) {
        DataSet billCount = QueryServiceHelper.queryDataSet((String)AppHomeToDoBusinessHelper.class.getName(), (String)entityName, (String)"id,billno", (QFilter[])billCountFilter.toArray(new QFilter[0]), null).distinct();
        return billCount.count("id", false);
    }

    private static List<Long> getHasViewPermOrgIds(long currUserId, String appId, String entityName) {
        List<Long> hasViewPermOrgIds = new ArrayList<Long>(10);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult != null) {
            hasViewPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        }
        return hasViewPermOrgIds;
    }
}

