/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.helper;

import java.util.Date;
import kd.bos.entity.datamodel.IDataModel;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import org.joda.time.DateTime;

public class DateRangeFilterHelper {
    private static final String TIME_FILTER_START_TIME = "daterange_start";
    private static final String TIME_FILTER_END_TIME = "daterange_end";
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static void setDefaultDateRangeThisWeek(IDataModel model) {
        Date startDate = DateUtils.getThisWeekStartDate();
        Date endDate = DateUtils.getThisWeekEndDate();
        model.setValue(TIME_FILTER_START_TIME, (Object)startDate);
        model.setValue(TIME_FILTER_END_TIME, (Object)endDate);
    }

    public static void setDateRangeFilter(Date startDate, Date endDate, String startDateType, String endDateType, MobileSearchParameter parameter) {
        if (startDate == null) {
            parameter.put((Object)startDateType, (Object)"*");
            parameter.put((Object)endDateType, (Object)"*");
        } else {
            if (endDate != null) {
                DateTime endDateTime = new DateTime((Object)endDate).plusDays(1);
                parameter.put((Object)endDateType, (Object)endDateTime.toString(TIME_PATTERN));
            } else {
                parameter.put((Object)endDateType, (Object)"*");
            }
            String startDateTime = new DateTime((Object)startDate).toString(TIME_PATTERN);
            parameter.put((Object)startDateType, (Object)startDateTime);
        }
    }

    private DateRangeFilterHelper() {
    }
}

