/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mobsp.common.helper.MutexAction;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiUtils;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.OpenApiDataSource;
import kd.scmc.msmob.mvccore.label.ILabelInterface;

public class PermissionHelper {
    private static final Log log = LogFactory.getLog(PermissionHelper.class);
    private static final String MODIFY = "modify";
    private static final String MUTEX = "mutex";

    public static boolean isAddModificationMutex(ILabelInterface requireMutexStatus, String billStatus) {
        return requireMutexStatus.getFieldValue().equals(billStatus);
    }

    public static boolean checkMutex(AbstractMobBillPlugIn plugIn, String pcEntityKey, String billStatus, ILabelInterface requireMutexStatus, Long billId, Long orgId) {
        if (PermissionHelper.isAddModificationMutex(requireMutexStatus, billStatus)) {
            StringBuilder errMsg = new StringBuilder();
            if (PermissionHelper.checkModify(plugIn, orgId, pcEntityKey)) {
                boolean networkExclusive = MutexHelper.require((IFormView)plugIn.getView(), (String)pcEntityKey, (Object)billId, (String)MODIFY, (boolean)Boolean.TRUE, (StringBuilder)errMsg);
                if (networkExclusive) {
                    return true;
                }
                Map<String, String> lockInfo = PermissionHelper.getLockInfo(pcEntityKey, MODIFY, billId);
                HashMap<String, String> lockRequireInfo = new HashMap<String, String>(3);
                lockRequireInfo.put("MUTEX_ENTITY_KEY", pcEntityKey);
                lockRequireInfo.put("MUTEX_OPER_KEY", MODIFY);
                lockRequireInfo.put("MUTEX_OBJ_ID", String.valueOf(billId));
                if (!CollectionUtils.isEmpty(lockInfo) && StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)lockInfo.get("userid")) && StringUtils.equals((CharSequence)MODIFY, (CharSequence)lockInfo.get("opkey"))) {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bd5", (String)"PermissionHelper_checkMutex_0", (String)"scm-mobsp-form", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f3a\u5236\u8e22\u51fa", (String)"PermissionHelper_checkMutex_1", (String)"scm-mobsp-form", (Object[])new Object[0]));
                    plugIn.getView().showConfirm(errMsg.toString(), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(MUTEX), btnNameMaps, SerializationUtils.toJsonString(lockRequireInfo));
                    plugIn.getView().getPageCache().put("billController:lockedConfirm", "true");
                } else {
                    plugIn.getView().showConfirm(String.valueOf(errMsg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MUTEX));
                }
            }
        }
        return false;
    }

    public static void mutexConfirmCallBack(IFormView view, MessageBoxClosedEvent messageBoxClosedEvent, MutexAction action) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((MUTEX.equals(callBackId) || MODIFY.equals(callBackId)) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            if (StringUtils.isNotEmpty((CharSequence)customVaule)) {
                String pkValue;
                String operationKey;
                Map lockRequireInfo = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
                String entityKey = (String)lockRequireInfo.get("MUTEX_ENTITY_KEY");
                Map<String, String> lockInfo = PermissionHelper.getLockInfo(entityKey, operationKey = (String)lockRequireInfo.get("MUTEX_OPER_KEY"), pkValue = (String)lockRequireInfo.get("MUTEX_OBJ_ID"));
                if (!CollectionUtils.isEmpty(lockInfo) && StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)lockInfo.get("userid")) && StringUtils.equals((CharSequence)MODIFY, (CharSequence)lockInfo.get("opkey"))) {
                    IFormMutexService service = (IFormMutexService)view.getService(IFormMutexService.class);
                    if (service != null) {
                        service.destoryLockingPage(entityKey, (Object)pkValue, operationKey, true, Collections.singletonList(view.getPageId()));
                    } else {
                        MutexHelper.clearErrLockByWebSocket((String)entityKey, (Object)pkValue, (String)operationKey);
                    }
                } else {
                    view.showTipNotification(PermissionHelper.recordFailTip(lockInfo));
                }
            }
            action.doAction();
        }
    }

    public static String recordFailTip(Map<String, String> lockInfo) {
        if (!CollectionUtils.isEmpty(lockInfo)) {
            String userName = null;
            String userIdStr = lockInfo.get("userid");
            if (userIdStr != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    userName = userObj.getString("name") + " ";
                }
            }
            return String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"PermissionHelper_recordFailTip_0", (String)"scm-mobsp-form", (Object[])new Object[0]), userName);
        }
        return ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"PermissionHelper_recordFailTip_1", (String)"scm-mobsp-form", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(String entityKey, String operationKey, Object billId) {
        String objId = billId.toString();
        if (!StringUtils.isNotBlank((CharSequence)entityKey)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)objId)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)operationKey)) return Collections.emptyMap();
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.getLockInfo(objId, groupId, entityKey);
            return map;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return Collections.emptyMap();
    }

    public static boolean setMutex(String status, ILabelInterface requireMutexStatus, String pcEntity, Long billId, IFormView view, Long orgId) {
        MutexHelper.release((IFormView)view.getParentView());
        boolean mutexFlag = true;
        if (requireMutexStatus.getFieldValue().equals(status)) {
            mutexFlag = MutexHelper.require((IFormView)view, (String)pcEntity, (Object)billId, (String)MODIFY, (boolean)true, (StringBuilder)new StringBuilder());
            if (mutexFlag) {
                String pcAppId = MetaUtils.getPcAppId((String)pcEntity);
                mutexFlag = PermissionHelper.checkPermission(orgId, pcAppId, pcEntity, "4715a0df000000ac");
            }
        } else {
            MutexHelper.release((IFormView)view);
        }
        return mutexFlag;
    }

    private static boolean checkModify(AbstractMobBillPlugIn plugin, Long orgId, String pcEntityKey) {
        String pcAppId = MetaUtils.getPcAppId((String)pcEntityKey);
        boolean hasModifyPerm = PermissionHelper.checkPermission(orgId, pcAppId, pcEntityKey, "4715a0df000000ac");
        if (!hasModifyPerm) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002\u662f\u5426\u8fdb\u5165\u67e5\u770b\u9875\u9762\uff1f", (String)"PermissionHelper_0", (String)"scm-mobsp-form", (Object[])new Object[0]);
            plugin.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFY));
            return false;
        }
        return true;
    }

    public static boolean checkPermission(Long orgId, String appId, String entityKey, String permItemId) {
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"15", (String)appId, (String)entityKey, (String)permItemId);
        return permission == 1;
    }

    public static String getPermItemId(String permItemNum) {
        String permItemId = "";
        String permItemEntity = "perm_permitem";
        DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)permItemEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)permItemNum)});
        for (DynamicObject dynObj : dynObjColl) {
            permItemId = dynObj.getString("id");
        }
        return permItemId;
    }

    public static <T extends AbstractMobBillPlugIn, N> boolean checkModifyAndMutex(T plugin, final long billId, final N detailVo, ILabelInterface requireMutexStatus, final String requestUrl, String statusType, String orgType, String pcEntity) {
        Object detailData = MobileApiUtils.getSingleData((IMobileApiSearch)new IMobileApiSearch<N>(){

            public OpenApiDataSource getDatasourceConfig() {
                return new OpenApiDataSource(requestUrl, detailVo.getClass());
            }

            public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
                parameter.put((Object)"id", (Object)billId);
                return parameter;
            }
        }, null);
        String getStatusMethodName = "get" + statusType.replaceFirst(statusType.substring(0, 1), statusType.substring(0, 1).toUpperCase());
        String getOrgMethodName = "get" + orgType.replaceFirst(orgType.substring(0, 1), orgType.substring(0, 1).toUpperCase());
        try {
            Method detailDataGetStatus = detailData.getClass().getMethod(getStatusMethodName, new Class[0]);
            String billStatus = (String)detailDataGetStatus.invoke(detailData, new Object[0]);
            Method detailDataGetOrg = detailData.getClass().getMethod(getOrgMethodName, new Class[0]);
            Object org = detailDataGetOrg.invoke(detailData, new Object[0]);
            Long orgId = org instanceof String ? Long.valueOf((String)org) : (Long)org;
            if (requireMutexStatus.getFieldValue().equals(billStatus)) {
                return PermissionHelper.checkMutex(plugin, pcEntity, billStatus, requireMutexStatus, billId, orgId);
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private PermissionHelper() {
    }
}

