/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.checkacc;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.mobsp.common.enums.ConfirmStatusEnum;
import kd.scm.mobsp.common.enums.OriginEnum;
import kd.scm.mobsp.common.utils.MobileControlUtils;
import kd.scm.mobsp.plugin.form.scp.checkacc.ICheckAccountPagePlugin;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillInfoTplPlugin;
import kd.scmc.msmob.common.utils.MetaUtils;

public class CheckAccountBillViewPlugin
extends MobScpBillInfoTplPlugin
implements ICheckAccountPagePlugin {
    private static final String PC_ID = "pcId";
    private static final String PC_ENTITY = "pcentity";

    @Override
    public void initBillInfo() {
        super.initBillInfo();
        this.setEntryTitle();
        this.setBtnVisible();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonreject"});
    }

    private void setEntryTitle() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(this.getEntryEntity());
        String entryLabelText = String.format(ResManager.loadKDString((String)"\u5165\u5e93/\u6536\u8d27\u660e\u7ec6\uff08\u5171%s\u6761\uff09", (String)"CheckAccountBillViewPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]), entryRowCount);
        MobileControlUtils.updateLabelText(this.getView(), "mldetails_label", entryLabelText);
    }

    public void setBtnVisible() {
        List allButtonKeys = this.getAllButtonKeys();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String cfmStatus = (String)model.getValue("cfmstatus");
        view.setVisible(Boolean.FALSE, allButtonKeys.toArray(new String[allButtonKeys.size()]));
        String origin = (String)model.getValue("origin");
        if (OriginEnum.PUR_ENTERPRISE.getValue().equals(origin)) {
            if (ConfirmStatusEnum.UNCONFIRM.getValue().equals(cfmStatus)) {
                view.setVisible(Boolean.TRUE, new String[]{"buttonreject", "buttonconfirm"});
                Control rejectButton = this.getControl("buttonreject");
                MobileControlUtils.controlSetFrontAndBackColor(rejectButton, "#000000", "#FFFFFF");
            } else if (ConfirmStatusEnum.CONFIRM.getValue().equals(cfmStatus)) {
                view.setVisible(Boolean.TRUE, new String[]{"buttonunconfirm"});
            }
            view.updateView("mtoolbarap");
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if ("buttonreject".equals(key)) {
            long userId = RequestContext.get().getCurrUserId();
            String pcAppId = MetaUtils.getPcAppId((String)this.getPcEntityKey());
            boolean permission = PermissionServiceHelper.checkPermission((Long)userId, (String)pcAppId, (String)this.getPcEntityKey(), (String)"4730fc9f000000ae");
            if (!permission) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u5bf9\u8d26\u5355\u201d\u7684\u201c\u6253\u56de\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CheckAccountBillViewPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            IPageCache pageCache = this.getPageCache();
            String pcId = pageCache.get(PC_ID);
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId("mobsp_confirmreject");
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reject"));
            formShowParameter.setCustomParam("id", (Object)pcId);
            formShowParameter.setCustomParam(PC_ENTITY, (Object)this.getPcEntityKey());
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("reject".equals(returnData) && closedCallBackEvent.getActionId().equals("reject")) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "btn_confirm": 
            case "unconfirm": 
            case "reject": {
                boolean isSuccess = args.getOperationResult().isSuccess();
                if (!isSuccess) break;
                this.updateData();
                break;
            }
        }
    }

    @Override
    public void updateData() {
        super.updateData();
        this.setLogStatus();
        this.setEntryTitle();
        this.setBtnVisible();
        this.getView().updateView();
    }
}

