/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.deliver;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.mobsp.business.helper.SaloutStockChangedHandler;
import kd.scm.mobsp.plugin.form.scp.deliver.ISaleOutStockPagePlugin;
import kd.scm.mobsp.plugin.form.scp.deliver.MaterialEntryViewPlugin;
import kd.scm.scp.common.util.ScpBillUtil;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillInfoTplPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;

public class MaterialEntryEditPlugin
extends MaterialEntryViewPlugin
implements ISaleOutStockPagePlugin,
IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(MobBillInfoTplPlugin.class);
    private static final String ROW_IDENTIFIER = "row";

    public MaterialEntryEditPlugin() {
        this.registerPropertyChangedHandler(new SaloutStockChangedHandler());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        int rowIndex = Integer.parseInt(this.getPageCache().get(ROW_IDENTIFIER));
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel parentModel = this.getParentModel();
        IFormView parentView = this.getParentView();
        if (Arrays.stream(MODEL_FIELD_KEYS).anyMatch(s -> s.equals(fieldKey))) {
            parentModel.beginInit();
            parentModel.setValue(fieldKey, newValue, rowIndex);
            if (fieldKey.equals("qty")) {
                this.checkQuantity(newValue, rowIndex);
            }
            parentModel.endInit();
            parentView.updateView("entryentity");
        }
    }

    private void checkQuantity(Object newValue, int rowIndex) {
        if (newValue == null) {
            LOG.warn("\u884c\u6807\u4e3a{}\u7684\u7269\u6599\u7684\u6570\u91cf\u4e3a\u7a7a\u3002", (Object)rowIndex);
            return;
        }
        BigDecimal newQuantity = (BigDecimal)newValue;
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig(this.getBillEditFormKey());
        String mobEntryKey = this.getEntryEntity();
        String pcEntryKey = DataSourceConfigHelper.getPcEntryKey((DataSourceConfig)dataSourceConfig, (String)mobEntryKey);
        DynamicObject pcEntityDy = this.getBill();
        DynamicObjectCollection entryColl = pcEntityDy.getDynamicObjectCollection(pcEntryKey);
        DynamicObject entryRow = (DynamicObject)entryColl.get(rowIndex);
        entryRow.set("qty", (Object)newQuantity);
        if (ScpBillUtil.compareQtyAndSumQty((DynamicObject)pcEntityDy, (int)rowIndex)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d1\u8d27\u6570\u91cf\u5c06\u5927\u4e8e\u6e90\u8ba2\u5355\u6570\u91cf\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8d85\u989d\u3002", (String)"MaterialEntryEditPlugin_checkQuantity_0", (String)"scm-mobsp-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cfm_callback_checkqty"));
        }
    }
}

