/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.deliver;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.scm.common.util.MaterialUtil;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class MaterialEntryViewPlugin
extends EntryEditTplPlugin {
    protected static final String PRODUCTION_DATE_FIELD = "proddate";
    protected static final String DUE_DATE_FIELD = "duedate";
    private static final String ENABLE_SHELF_LIFE_MGR = "enableshelflifemgr";
    private static final String MATERIAL_FIELD = "material";
    private static final String PARENT_ORG_FIELD = "org";
    protected static final String QUANTITY_FIELD = "qty";
    protected static final String NEXT_BUTTON = "godownuo";
    protected static final String PREVIOUS_BUTTON = "goupop";
    protected static final String[] MODEL_FIELD_KEYS = new String[]{"pcentitykey", "billid", "unit", "qty", "material", "proddate", "duedate"};

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.triggerDateVisibility();
    }

    private void triggerDateVisibility() {
        IFormView view = this.getView();
        DynamicObject materialInfo = this.getModel().getDataEntity();
        DynamicObject material = materialInfo.getDynamicObject(MATERIAL_FIELD);
        if (material != null) {
            HashSet<Long> materialSet = new HashSet<Long>();
            Long orgId = (Long)((DynamicObject)this.getParentModel().getValue(PARENT_ORG_FIELD)).getPkValue();
            materialSet.add((Long)material.getPkValue());
            Map materialMap = MaterialUtil.getMaterialInventoryinfo(materialSet, (long)orgId, (String)"materialid,id,enablelot,enableshelflifemgr");
            DynamicObject materialInvInfo = (DynamicObject)materialMap.get(material.getPkValue());
            boolean isEnableShelfLife = materialInvInfo != null && materialInvInfo.getBoolean(ENABLE_SHELF_LIFE_MGR);
            view.setEnable(Boolean.valueOf(isEnableShelfLife), new String[]{PRODUCTION_DATE_FIELD, DUE_DATE_FIELD});
            view.setVisible(Boolean.valueOf(isEnableShelfLife), new String[]{PRODUCTION_DATE_FIELD, DUE_DATE_FIELD});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (NEXT_BUTTON.equals(key) || PREVIOUS_BUTTON.equals(key)) {
            this.triggerDateVisibility();
        }
    }
}

