/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.deliver;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.scm.mobsp.common.enums.SaloutStockLogStatusEnum;
import kd.scm.mobsp.common.utils.MobileControlUtils;
import kd.scm.mobsp.plugin.form.scp.deliver.ISaleOutStockPagePlugin;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillInfoTplPlugin;
import kd.scmc.msmob.common.enums.BillStatusEnum;

public class SaloutStockBillViewPlugin
extends MobScpBillInfoTplPlugin
implements ISaleOutStockPagePlugin {
    @Override
    public void initBillInfo() {
        super.initBillInfo();
        this.setLogStatus();
        this.setBtnVisible();
    }

    public void setBtnVisible() {
        super.setBtnVisible();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        String logStatus = (String)model.getValue("logstatus");
        view.setVisible(Boolean.TRUE, new String[]{"buttonclose"});
        if (StringUtils.isNotEmpty((CharSequence)billStatus) && StringUtils.isNotEmpty((CharSequence)logStatus) && BillStatusEnum.AUDIT.getValue().equals(billStatus) && SaloutStockLogStatusEnum.UNRECEIVED.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"buttonunaudit"});
            Control closeButton = this.getControl("buttonclose");
            MobileControlUtils.controlSetFrontAndBackColor(closeButton, "#000000", "#FFFFFF");
            HashMap<String, Object> styleParameters = MobileControlUtils.getButtonBorderStyle();
            view.updateControlMetadata("buttonclose", styleParameters);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"buttonunaudit"});
        }
    }

    @Override
    public void setLogStatus() {
        super.setLogStatus();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{"unreceived", "partialreceive", "receive", "partialstorage", "storage", "reject"});
        String logStatus = (String)model.getValue("logstatus");
        if (logStatus != null) {
            if (logStatus.equals(SaloutStockLogStatusEnum.UNRECEIVED.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"unreceived"});
            } else if (logStatus.equals(SaloutStockLogStatusEnum.PARTIAL_RECEIVE.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"partialreceive"});
            } else if (logStatus.equals(SaloutStockLogStatusEnum.RECEIVE.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"receive"});
            } else if (logStatus.equals(SaloutStockLogStatusEnum.PARTIAL_STORAGE.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"partialstorage"});
            } else if (logStatus.equals(SaloutStockLogStatusEnum.STORAGE.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"storage"});
            } else if (logStatus.equals(SaloutStockLogStatusEnum.REJECT.getValue())) {
                view.setVisible(Boolean.TRUE, new String[]{"reject"});
            }
        }
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryViewFormKey(entryKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "unaudit": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.unDeliver();
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Object source = e.getSource();
        if (source instanceof Button && "buttonaudit".equals(((Button)source).getKey())) {
            this.updateData();
            this.setLogStatus();
            this.setBtnVisible();
        }
    }

    private void unDeliver() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String successMsg = ResManager.loadKDString((String)"\u64a4\u9500\u53d1\u8d27\u6210\u529f\u3002", (String)"SaloutStockBillViewPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]);
        view.showSuccessNotification(successMsg);
        Boolean isModify = this.checkModifyPermission();
        if (Boolean.TRUE.equals(isModify)) {
            MobileFormShowParameter formShowParameter = this.createShowParameter(this.getEditFormId(), false);
            this.goUrl(formShowParameter, true);
        } else {
            model.setValue("billstatus", (Object)"A");
            view.updateView();
        }
    }

    public String getEditFormId() {
        return this.getBillEditFormKey();
    }

    protected String getMainEntryTitle() {
        String entryKey = this.getEntryEntity();
        int entryRowCount = this.getModel().getEntryRowCount(entryKey);
        return String.valueOf(entryRowCount);
    }
}

