/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.enroll;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.helper.DateRangeFilterHelper;
import kd.scm.mobsp.common.helper.SourcingAPIQueryParamHelper;
import kd.scm.mobsp.plugin.form.scp.enroll.vo.EnrollListResult;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileOpenApiPluginHelper;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class EnrollBillListPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<EnrollListResult>,
IDataModelChangeListener,
IMobileApiPage {
    private static final String TIME_FILTER_START = "daterange_start";
    private static final String TIME_FILTER_END = "daterange_end";
    private static final String TENDER_DATE_FILTER_START = "tenderdaterange_start";
    private static final String TENDER_DATE_FILTER_END = "tenderdaterange_end";
    private static final String ENROLL_STATUS_FILTER = "enrollstatusfilter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileOpenApiPluginHelper.addEntryPageListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addMobileSearchTextListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addRowClickListener((AbstractFormPlugin)this, (value, mobileFormShowParameter) -> {
            mobileFormShowParameter.setFormId("mobsp_sourcing_enrollbill");
            mobileFormShowParameter.setCustomParam("id", (Object)value.getId());
            return mobileFormShowParameter;
        });
        this.addPullRefreshListener();
    }

    private void addPullRefreshListener() {
        CardEntry card = (CardEntry)this.getView().getControl(MobileViewModelUtils.getFirstEntryName((AbstractFormPlugin)this));
        EnrollBillListPlugin plugin = this;
        card.addPullRefreshlisteners(evt -> MobileApiRendererUtils.renderListPage((AbstractFormPlugin)plugin));
    }

    public void afterCreateNewData(EventObject e) {
        DateRangeFilterHelper.setDefaultDateRangeThisWeek(this.getModel());
        super.afterCreateNewData(e);
        MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
    }

    public OpenApiDataSource<EnrollListResult> getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_query/getList", EnrollListResult.class, false);
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
        Date dateRangeStart = (Date)this.getModel().getValue(TIME_FILTER_START);
        Date dateRangeEnd = (Date)this.getModel().getValue(TIME_FILTER_END);
        Date tenderDateFilterStart = (Date)this.getModel().getValue(TENDER_DATE_FILTER_START);
        Date tenderDateFilterEnd = (Date)this.getModel().getValue(TENDER_DATE_FILTER_END);
        String selectedEnrollStatus = (String)this.getModel().getValue(ENROLL_STATUS_FILTER);
        return new SourcingAPIQueryParamHelper((AbstractFormPlugin)this).setEnrollStatus(selectedEnrollStatus).setDateRange(dateRangeStart, dateRangeEnd).setTenderEndDateRange(tenderDateFilterStart, tenderDateFilterEnd).setSearchParameter().setFormId("tnd_apply").buildWrap();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (TIME_FILTER_START.equals(propName) || TIME_FILTER_END.equals(propName) || ENROLL_STATUS_FILTER.equals(propName) || TENDER_DATE_FILTER_START.equals(propName) || TENDER_DATE_FILTER_END.equals(propName)) {
            MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
        }
    }

    public String getPcEntity() {
        return "tnd_apply";
    }
}

