/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.quote;

import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.helper.PermissionHelper;
import kd.scm.mobsp.plugin.form.scp.quote.component.QuoteComponentHandler;
import kd.scm.mobsp.plugin.form.scp.quote.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteCopyEntryHandler;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteDeleteEntryHandler;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteRevokeHandler;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteSaveHandler;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteSubmitHandler;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiResultHandler;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiCRUDUtils;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileOpenApiPluginHelper;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class QuoteDetailPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<QuoteBillDetailVo>,
IMobileApiPage {
    private static final String MOBILE_ENTRY_NAME = "entryentity";
    private static final String ENTRY_DISPLAY_MODE = "entryDisplayMode";
    private static final String QUOTE_BTN = "quotebtn";
    private static final String SAVE_BTN = "savebtn";
    private static final String REVOKE_BTN = "revoke";
    private static final String TOOL_BAR = "mtoolbarap";
    private static final String HIDE_BTN = "collapse_hide";
    private static final String DISPLAY_BTN = "collapse_display";
    private static final String FLEX_INFO_PANEL = "flexpanelap1";
    private static final String DELETE_ENTRY_BTN = "delete_entry_btn";
    private static final String COPY_ENTRY_BTN = "copy_entry_btn";

    public OpenApiDataSource getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_quotebill/getDetail", QuoteBillDetailVo.class);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileViewModelUtils.addEntryToPageListener((AbstractFormPlugin)this, (String)MOBILE_ENTRY_NAME, (value, mobileFormShowParameter) -> {
            String entryDisplayMode = this.getView().getPageCache().get(ENTRY_DISPLAY_MODE);
            String openStatus = this.getView().getPageCache().get("open_status");
            mobileFormShowParameter.setCustomParam("entry_display_mode", (Object)entryDisplayMode);
            mobileFormShowParameter.setCustomParam("open_status", (Object)openStatus);
            mobileFormShowParameter.setFormId("mobsp_quote_entry_view");
            return mobileFormShowParameter;
        });
        this.addClickListeners(new String[]{HIDE_BTN, DISPLAY_BTN});
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)QUOTE_BTN, (ClickListener)new QuoteSubmitHandler(this.getView()));
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)SAVE_BTN, (ClickListener)new QuoteSaveHandler(this.getView()));
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)REVOKE_BTN, (ClickListener)new QuoteRevokeHandler(this.getView()));
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)DELETE_ENTRY_BTN, (ClickListener)new QuoteDeleteEntryHandler(this));
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)COPY_ENTRY_BTN, (ClickListener)new QuoteCopyEntryHandler(this));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "collapse_hide": {
                this.displayQuoteInfo(false);
                break;
            }
            case "collapse_display": {
                this.displayQuoteInfo(true);
                break;
            }
        }
    }

    private void displayQuoteInfo(boolean show) {
        IFormView view = this.getView();
        if (show) {
            view.setVisible(Boolean.valueOf(true), new String[]{FLEX_INFO_PANEL, HIDE_BTN});
            view.setVisible(Boolean.valueOf(false), new String[]{DISPLAY_BTN});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{FLEX_INFO_PANEL, HIDE_BTN});
            view.setVisible(Boolean.valueOf(true), new String[]{DISPLAY_BTN});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setViewFromData();
    }

    public void setViewFromData() {
        QuoteBillDetailVo detailVo = (QuoteBillDetailVo)((Object)MobileApiRendererUtils.renderSingDataPage((AbstractFormPlugin)this, (IMobileApiResultHandler)new QuoteComponentHandler()));
        String billStatus = detailVo.getBillstatus();
        String openStatus = detailVo.getProject_openstatus();
        this.getView().getPageCache().put("open_status", openStatus);
        boolean mutex = PermissionHelper.setMutex(billStatus, BillStatusEnum.SAVE, this.getPcEntity(), detailVo.getId(), this.getView(), detailVo.getOrg_id());
        this.setButtonVisible(detailVo, mutex);
        this.displayQuoteInfo(true);
    }

    public void setViewFromData(QuoteBillDetailVo detailVo) {
        String billStatus = detailVo.getBillstatus();
        String openStatus = detailVo.getProject_openstatus();
        this.getView().getPageCache().put("open_status", openStatus);
        boolean mutex = PermissionHelper.setMutex(billStatus, BillStatusEnum.SAVE, this.getPcEntity(), detailVo.getId(), this.getView(), detailVo.getOrg_id());
        this.setButtonVisible(detailVo, mutex);
    }

    private void setButtonVisible(QuoteBillDetailVo detailVo, boolean flag) {
        int i;
        String billStatus = detailVo.getBillstatus();
        this.getView().getPageCache().put(ENTRY_DISPLAY_MODE, "can_not_modify");
        CardEntry entryEntityView = (CardEntry)this.getView().getControl(MOBILE_ENTRY_NAME);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MOBILE_ENTRY_NAME);
        for (i = 0; i < entryEntity.size(); ++i) {
            entryEntityView.setChildVisible(false, i, new String[]{"delete_copy_container"});
            entryEntityView.setChildVisible(false, i, new String[]{DELETE_ENTRY_BTN});
            if (detailVo.getEntryentity().get(i).getIsnew().booleanValue()) {
                entryEntityView.setChildVisible(true, i, new String[]{"new_target_label"});
                continue;
            }
            entryEntityView.setChildVisible(false, i, new String[]{"new_target_label"});
        }
        if (BillStatusEnum.SAVE.getFieldValue().equals(billStatus) && flag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVOKE_BTN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE_BTN, QUOTE_BTN});
            this.getView().getPageCache().put(ENTRY_DISPLAY_MODE, "can_modify");
            if (detailVo.getIsadd().booleanValue() && detailVo.getTurns() == 1) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    entryEntityView.setChildVisible(true, i, new String[]{"delete_copy_container"});
                    if (!detailVo.getEntryentity().get(i).getIsnew().booleanValue()) continue;
                    entryEntityView.setChildVisible(true, i, new String[]{DELETE_ENTRY_BTN});
                }
            }
        }
        if (!flag || BillStatusEnum.SUBMIT.getFieldValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TOOL_BAR});
        }
        if (BillStatusEnum.AUDIT.getFieldValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_BTN, QUOTE_BTN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{REVOKE_BTN});
        }
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameterMap) {
        MobileOpenApiPluginHelper.addIdParameter((AbstractFormPlugin)this, (MobileSearchParameter)parameterMap);
        return parameterMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        MobileApiCRUDUtils.addOperationParameter((AbstractFormPlugin)this, (BeforeDoOperationEventArgs)args);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        QuoteBillDetailVo detailVo = (QuoteBillDetailVo)((Object)MobileApiRendererUtils.refreshSingleDataPageOnClose((IMobileApiPage)this, (ClosedCallBackEvent)closedCallBackEvent));
        this.setViewFromData(detailVo);
    }

    public String getPcEntity() {
        return "tnd_quotebill";
    }
}

