/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.quote.vo;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.mobsp.common.entity.componentvo.SrcPurListStandEntryResult;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteSaveEntry;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteSaveModel;
import kd.scmc.msmob.mvccore.ReservedFieldVo;

public class QuoteSaveVo
extends ReservedFieldVo {
    private QuoteSaveModel quoteModel = new QuoteSaveModel();

    public QuoteSaveVo(QuoteBillDetailVo vo) {
        List<SrcPurListStandEntryResult> entryentity = vo.getEntryentity();
        if (entryentity != null) {
            List<QuoteSaveEntry> collect = entryentity.stream().map(entryResult -> {
                QuoteSaveEntry quoteSaveEntry = new QuoteSaveEntry();
                quoteSaveEntry.setId(entryResult.getId());
                quoteSaveEntry.setPrice(entryResult.getPrice());
                quoteSaveEntry.setTaxprice(entryResult.getTaxprice());
                quoteSaveEntry.setAmount(entryResult.getAmount());
                quoteSaveEntry.setTaxamount(entryResult.getTaxamount());
                quoteSaveEntry.setCurrencyId(entryResult.getCurrency_id());
                quoteSaveEntry.setTaxItemId(entryResult.getTaxitem_id());
                quoteSaveEntry.setNote(entryResult.getNote());
                quoteSaveEntry.setQty(entryResult.getQty());
                if (entryResult.getTaxitem_id() != null && entryResult.getTaxitem_id() > 0L) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)entryResult.getTaxitem_id(), (String)"bd_taxrate");
                    quoteSaveEntry.setTaxRate(dynamicObject.getBigDecimal("taxrate"));
                } else {
                    quoteSaveEntry.setTaxRate(BigDecimal.ZERO);
                    quoteSaveEntry.setTaxItemId(null);
                }
                quoteSaveEntry.setReservedFieldsFromAnother((ReservedFieldVo)entryResult);
                quoteSaveEntry.setIsnew(entryResult.getIsnew());
                quoteSaveEntry.setMaterialname(entryResult.getMaterialnane());
                quoteSaveEntry.setDescription(entryResult.getDescription());
                quoteSaveEntry.setModel(entryResult.getMaterialmodel());
                quoteSaveEntry.setBrand(entryResult.getBrand());
                quoteSaveEntry.setSupAttchId(entryResult.getPurlistentry_supfj_ids());
                if (entryResult.getIsnew().booleanValue()) {
                    quoteSaveEntry.setPurlistid(entryResult.getPurlist_id());
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    fieldMap.put("srcentryid", String.valueOf(entryResult.getCopy_id()));
                    quoteSaveEntry.setCustomPro(JSON.toJSONString(fieldMap));
                }
                return quoteSaveEntry;
            }).collect(Collectors.toList());
            this.quoteModel.setEntry(collect);
        }
        this.quoteModel.setId(vo.getId());
    }

    public QuoteSaveVo() {
    }

    public QuoteSaveModel getQuoteModel() {
        return this.quoteModel;
    }

    public void setQuoteModel(QuoteSaveModel quoteModel) {
        this.quoteModel = quoteModel;
    }

    public String toString() {
        return "QuoteSaveVo{quoteModel=" + (Object)((Object)this.quoteModel) + '}';
    }
}

