/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register;

import java.security.SecureRandom;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CountDown;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.util.MD5Util;
import kd.scm.mobsp.business.helper.RegisterValidateCodeResult;

public class ValidateCodeSupportHelper {
    public static final String VERIFICATION_CODE = "verificationCode";
    public static final String RANDOM_STR = "randomStr";
    public static final String CODE_TIME = "code_time";
    public static final String CODE_COUNT = "code_count";
    public static final int VALID_COUNT = 5;
    public static final long VALID_MINUTE = 5L;
    public static final int TIME_CONVERSION_RATE = 60000;

    public static void registerCaptchaButtonListener(AbstractFormPlugin formPlugin) {
        Button getMsg = (Button)formPlugin.getView().getControl("getmsg");
        getMsg.addClickListener((ClickListener)formPlugin);
        ValidateCodeSupportHelper.addOnProgressListener(formPlugin, "progressbarap", "getmsg", "countdown");
    }

    private static void addOnProgressListener(AbstractFormPlugin dataModelPlugin, String progress, String getmsg, String countdown) {
        ProgressBar control = (ProgressBar)dataModelPlugin.getControl(progress);
        control.addProgressListener(progressEvent -> {
            ProgressBar progressBar = (ProgressBar)dataModelPlugin.getControl(progress);
            progressBar.stop();
            dataModelPlugin.getView().setVisible(Boolean.TRUE, new String[]{getmsg});
            dataModelPlugin.getView().setVisible(Boolean.FALSE, new String[]{countdown});
            dataModelPlugin.getView().updateView();
        });
    }

    public static void handleCaptchaCode(String mobileNumber, AbstractFormPlugin formPlugin, RegisterValidateCodeResult result, String errorTitle) {
        IFormView view = formPlugin.getView();
        if (result.isSuccess()) {
            String verificationCode = result.getVerificationCode();
            if (verificationCode != null) {
                String tips = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001", (String)"RegisterPlugin_5", (String)"scm-mobsp-form", (Object[])new Object[0]);
                view.showMessage(tips);
                String randomStr = ValidateCodeSupportHelper.createRandNum();
                view.getPageCache().put(RANDOM_STR, randomStr + mobileNumber);
                String encode = MD5Util.encode((String)(randomStr + mobileNumber + verificationCode));
                view.getPageCache().put(VERIFICATION_CODE, encode);
                Date date = new Date();
                view.getPageCache().put(CODE_TIME, String.valueOf(date.getTime()));
                view.getPageCache().put(CODE_COUNT, String.valueOf(0));
                view.setVisible(Boolean.FALSE, new String[]{"getmsg"});
                view.setVisible(Boolean.TRUE, new String[]{"countdown"});
                view.updateView("countdown");
                ProgressBar progress = (ProgressBar)view.getControl("progressbarap");
                progress.start();
                CountDown countDown = (CountDown)view.getControl("countdown");
                countDown.setDuration(60);
                countDown.start();
            }
            return;
        }
        String msg = result.getErrorMsg();
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            view.showConfirm(errorTitle, msg, MessageBoxOptions.None, ConfirmTypes.Fail, null);
        }
    }

    public static void setInvisibleOnPageInit(AbstractFormPlugin formPlugin) {
        formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"countdown"});
        formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
    }

    public static void setGetMsgEnable(AbstractFormPlugin formPlugin) {
        IDataModel model = formPlugin.getView().getModel();
        boolean isEnable = true;
        Object num = model.getValue("number");
        if (num == null || StringUtils.isEmpty((CharSequence)String.valueOf(num).trim())) {
            isEnable = false;
        }
        formPlugin.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"getmsg"});
    }

    public static String createRandNum() {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 5; ++i) {
            String s = random.nextInt(10) + "";
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean checkValidateCode(AbstractFormPlugin formPlugin) {
        long startTime;
        long minute;
        Object code;
        IPageCache pageCache = formPlugin.getPageCache();
        String count = pageCache.get(CODE_COUNT);
        if (StringUtils.isNotEmpty((CharSequence)count)) {
            int parseInt = Integer.parseInt(count);
            formPlugin.getPageCache().put(CODE_COUNT, String.valueOf(parseInt + 1));
        }
        if ((code = formPlugin.getView().getModel().getValue("validatecode")) == null || StringUtils.isEmpty((CharSequence)code.toString())) {
            String tips = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterPlugin_3", (String)"scm-mobsp-form", (Object[])new Object[0]);
            formPlugin.getView().showMessage(tips);
            return false;
        }
        String countStr = formPlugin.getPageCache().get(CODE_COUNT);
        String timeStr = formPlugin.getPageCache().get(CODE_TIME);
        if (countStr != null && Integer.parseInt(countStr) > 5) {
            String tips = ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"RegisterPlugin_6", (String)"scm-mobsp-form", (Object[])new Object[0]);
            formPlugin.getView().showMessage(tips);
            return false;
        }
        Date currDate = new Date();
        long currTime = currDate.getTime();
        if (timeStr != null && (minute = (currTime - (startTime = Long.parseLong(timeStr))) / 60000L) > 5L) {
            String tips = ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"RegisterPlugin_7", (String)"scm-mobsp-form", (Object[])new Object[0]);
            formPlugin.getView().showMessage(tips);
            return false;
        }
        String randomStr = formPlugin.getPageCache().get(RANDOM_STR);
        String verificationCode = formPlugin.getPageCache().get(VERIFICATION_CODE);
        String enterCode = MD5Util.encode((String)(randomStr + code));
        if (!enterCode.equals(verificationCode) && !code.equals(verificationCode)) {
            String tips = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"RegisterPlugin_4", (String)"scm-mobsp-form", (Object[])new Object[0]);
            formPlugin.getView().showMessage(tips);
            return false;
        }
        return true;
    }
}

