/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.EventObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.plugin.form.scp.register.RegisterPluginHelper;
import kd.scm.mobsp.plugin.form.scp.register.input.AbstractItemInput;
import kd.scm.mobsp.plugin.form.scp.register.input.SupplierRegisterInformationPlugin;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobDataModelPlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractItemInputPlugin
extends AbstractMobDataModelPlugin {
    private static final String SAVE_AND_CONTINUE = "save_and_continue";
    private static final String SAVE = "save";
    private static final String RETURN = "return";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE_AND_CONTINUE, SAVE, RETURN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RegisterPluginHelper.setFieldValuesFromDataSourceConfig((AbstractFormPlugin)this, this.getModel(), this.curData[0]);
        this.setButtonVisibility();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "return": {
                this.closeItemInputPage();
                break;
            }
        }
    }

    private void closeItemInputPage() {
        this.getView().close();
    }

    private void setButtonVisibility() {
        boolean isLast;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer inputIndex = (Integer)formShowParameter.getCustomParam("inputIndex");
        boolean bl = isLast = inputIndex == SupplierRegisterInformationPlugin.ITEM_INPUTS.size() - 1;
        if (isLast) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_AND_CONTINUE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE_AND_CONTINUE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE});
        }
    }

    public FilterConstructor getFilterConstructor(FilterConstructor filterConstructor) {
        return RegisterPluginHelper.getFilterConstructor(this, filterConstructor);
    }

    public void updateData() {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || StringUtils.isNotEmpty((CharSequence)operationResult.getMessage()) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save_and_continue": {
                this.goToNextInputPage();
                this.getView().close();
                break;
            }
            case "save": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }

    private void goToNextInputPage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer inputIndex = (Integer)formShowParameter.getCustomParam("inputIndex");
        int nextIndex = inputIndex + 1;
        AbstractItemInput inputEntry = SupplierRegisterInformationPlugin.ITEM_INPUTS.get(nextIndex);
        String targetPage = inputEntry.getTargetPage();
        MobileFormShowParameter nextPageShowParameter = new MobileFormShowParameter();
        nextPageShowParameter.setFormId(targetPage);
        nextPageShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        nextPageShowParameter.setCustomParam("number", this.getModel().getValue("number"));
        nextPageShowParameter.setCustomParam("inputIndex", (Object)nextIndex);
        nextPageShowParameter.setCloseCallBack(formShowParameter.getCloseCallBack());
        nextPageShowParameter.setParentFormId("mobsp_register_input");
        nextPageShowParameter.setParentPageId(formShowParameter.getParentPageId());
        nextPageShowParameter.setCloseCallBack(formShowParameter.getCloseCallBack());
        this.getView().showForm((FormShowParameter)nextPageShowParameter);
    }
}

