/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.EventObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.mobsp.plugin.form.scp.register.input.AbstractItemInputPlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractItemInputWithEntryPlugin
extends AbstractItemInputPlugin {
    private static final String DELETE_BUTTON = "deleteop";
    private static final String EDIT_BUTTON = "editop";
    protected static final String ENTRY_INDEX = "entryIndex";
    private static final String ENTRY_EDIT_CLOSED_EVENT = "entry_edit_closed_event";
    protected String addEntryButton;

    public abstract String getEntryName();

    public abstract String getEditPageName();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DELETE_BUTTON, EDIT_BUTTON});
        if (StringUtils.isNotEmpty((CharSequence)this.addEntryButton)) {
            this.addClickListeners(new String[]{this.addEntryButton});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        IDataModel model = this.getModel();
        switch (key = c.getKey()) {
            case "deleteop": {
                this.deleteEntry();
                break;
            }
            case "editop": {
                int rowIndex = model.getEntryCurrentRowIndex(this.getEntryName());
                this.editEntry(rowIndex);
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.addEntryButton) && this.addEntryButton.equals(key)) {
            this.addEntry();
        }
    }

    protected void deleteEntry() {
        IDataModel model = this.getModel();
        int deleteRowIndex = model.getEntryCurrentRowIndex(this.getEntryName());
        if (deleteRowIndex < 0) {
            return;
        }
        model.deleteEntryRow(this.getEntryName(), deleteRowIndex);
    }

    private void addEntry() {
        this.editEntry(null);
    }

    private void editEntry(Integer index) {
        IDataModel model = this.getModel();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(this.getEditPageName());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam(ENTRY_INDEX, (Object)index);
        CloseCallBack agreementClosed = new CloseCallBack((IFormPlugin)this, ENTRY_EDIT_CLOSED_EVENT);
        formShowParameter.setCloseCallBack(agreementClosed);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
    }
}

